/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexthopUnnumberedIPv4IDTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(NexthopUnnumberedIPv4IDTlv.class);
    public static final short TYPE = 1;
    public static final short LENGTH = 12;
    private final int nodeID;
    private final int interfaceID;

    public NexthopUnnumberedIPv4IDTlv(int nodeID, int interfaceID) {
        this.nodeID = nodeID;
        this.interfaceID = interfaceID;
    }

    public static NexthopUnnumberedIPv4IDTlv of(int nodeID, int interfaceID) {
        return new NexthopUnnumberedIPv4IDTlv(nodeID, interfaceID);
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public int getInterfaceID() {
        return this.interfaceID;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 1;
    }

    @Override
    public short getLength() {
        return 12;
    }

    public int hashCode() {
        return Objects.hash(this.nodeID, this.interfaceID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NexthopUnnumberedIPv4IDTlv) {
            NexthopUnnumberedIPv4IDTlv other = (NexthopUnnumberedIPv4IDTlv)obj;
            return Objects.equals(this.nodeID, other.nodeID) && Objects.equals(this.interfaceID, other.interfaceID);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(1);
        c.writeShort(12);
        c.writeInt(this.nodeID);
        c.writeInt(this.interfaceID);
        return c.writerIndex() - iLenStartIndex;
    }

    public static NexthopUnnumberedIPv4IDTlv read(ChannelBuffer cb) {
        int nodeID = cb.readInt();
        int interfaceID = cb.readInt();
        return new NexthopUnnumberedIPv4IDTlv(nodeID, interfaceID);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 1).add("Length", 12).add("NodeId", this.nodeID).add("InterfaceId", this.interfaceID).toString();
    }
}

