/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexthopIPv4addressTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(NexthopIPv4addressTlv.class);
    public static final short TYPE = -247;
    public static final short LENGTH = 8;
    public static final short VALUE_LENGTH = 4;
    private final int rawValue;

    public NexthopIPv4addressTlv(int rawValue) {
        this.rawValue = rawValue;
    }

    public static NexthopIPv4addressTlv of(int raw) {
        return new NexthopIPv4addressTlv(raw);
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return -247;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        return Objects.hash(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NexthopIPv4addressTlv) {
            NexthopIPv4addressTlv other = (NexthopIPv4addressTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iStartIndex = c.writerIndex();
        c.writeShort(-247);
        c.writeShort(4);
        c.writeInt(this.rawValue);
        return c.writerIndex() - iStartIndex;
    }

    public static NexthopIPv4addressTlv read(ChannelBuffer c) {
        return NexthopIPv4addressTlv.of(c.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", -247).add("Length", 4).add("Ipv4Address ", this.rawValue).toString();
    }
}

