/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsCapabilityTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(LsCapabilityTlv.class);
    public static final short TYPE = -256;
    public static final short LENGTH = 4;
    public static final int SET = 1;
    public static final byte RFLAG_CHECK = 1;
    private final boolean rFlag;
    private final int rawValue;
    private final boolean isRawValueSet;

    public LsCapabilityTlv(int rawValue) {
        this.rawValue = rawValue;
        this.isRawValueSet = true;
        int temp = rawValue;
        this.rFlag = (temp &= 1) == 1;
    }

    public LsCapabilityTlv(boolean rFlag) {
        this.rFlag = rFlag;
        this.rawValue = 0;
        this.isRawValueSet = false;
    }

    public boolean getrFlag() {
        return this.rFlag;
    }

    public static LsCapabilityTlv of(int raw) {
        return new LsCapabilityTlv(raw);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public short getType() {
        return -256;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        if (this.isRawValueSet) {
            return Objects.hash(this.rawValue);
        }
        return Objects.hash(this.rFlag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LsCapabilityTlv) {
            LsCapabilityTlv other = (LsCapabilityTlv)obj;
            if (this.isRawValueSet) {
                return Objects.equals(this.rawValue, other.rawValue);
            }
            return Objects.equals(this.rFlag, other.rFlag);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iStartIndex = c.writerIndex();
        int temp = 0;
        c.writeShort(-256);
        c.writeShort(4);
        if (this.isRawValueSet) {
            c.writeInt(this.rawValue);
        } else {
            if (this.rFlag) {
                temp |= 1;
            }
            c.writeInt(temp);
        }
        return c.writerIndex() - iStartIndex;
    }

    public static LsCapabilityTlv read(ChannelBuffer c) {
        return LsCapabilityTlv.of(c.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", -256).add("Length", 4).add("Value", this.rawValue).toString();
    }
}

