/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.AdministrativeGroupSubTlv;
import org.onosproject.pcepio.types.IPv4RouterIdOfLocalNodeSubTlv;
import org.onosproject.pcepio.types.IPv4RouterIdOfRemoteNodeSubTlv;
import org.onosproject.pcepio.types.IPv6RouterIdofLocalNodeSubTlv;
import org.onosproject.pcepio.types.IPv6RouterIdofRemoteNodeSubTlv;
import org.onosproject.pcepio.types.IgpMetricSubTlv;
import org.onosproject.pcepio.types.LinkLocalRemoteIdentifiersSubTlv;
import org.onosproject.pcepio.types.LinkNameAttributeSubTlv;
import org.onosproject.pcepio.types.LinkProtectionTypeSubTlv;
import org.onosproject.pcepio.types.MaximumLinkBandwidthSubTlv;
import org.onosproject.pcepio.types.MaximumReservableLinkBandwidthSubTlv;
import org.onosproject.pcepio.types.MplsProtocolMaskSubTlv;
import org.onosproject.pcepio.types.OpaqueLinkAttributeSubTlv;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.SharedRiskLinkGroupSubTlv;
import org.onosproject.pcepio.types.TEDefaultMetricSubTlv;
import org.onosproject.pcepio.types.UnreservedBandwidthSubTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkAttributesTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(LinkAttributesTlv.class);
    public static final short TYPE = -250;
    short hLength;
    public static final int TLV_HEADER_LENGTH = 4;
    private List<PcepValueType> llLinkAttributesSubTLVs;

    public LinkAttributesTlv(List<PcepValueType> llLinkAttributesSubTLVs) {
        this.llLinkAttributesSubTLVs = llLinkAttributesSubTLVs;
    }

    public static LinkAttributesTlv of(List<PcepValueType> llLinkAttributesSubTLVs) {
        return new LinkAttributesTlv(llLinkAttributesSubTLVs);
    }

    public List<PcepValueType> getllLinkAttributesSubTLVs() {
        return this.llLinkAttributesSubTLVs;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return -250;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(this.llLinkAttributesSubTLVs.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinkAttributesTlv) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            LinkAttributesTlv other = (LinkAttributesTlv)obj;
            Iterator<PcepValueType> objListIterator = ((LinkAttributesTlv)obj).llLinkAttributesSubTLVs.iterator();
            countObjSubTlv = ((LinkAttributesTlv)obj).llLinkAttributesSubTLVs.size();
            if (countObjSubTlv != (countOtherSubTlv = other.llLinkAttributesSubTLVs.size())) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                PcepValueType subTlv = objListIterator.next();
                isCommonSubTlv = Objects.equals(this.llLinkAttributesSubTLVs.contains(subTlv), other.llLinkAttributesSubTLVs.contains(subTlv));
            }
            return isCommonSubTlv;
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int tlvStartIndex = c.writerIndex();
        c.writeShort(-250);
        int tlvLenIndex = c.writerIndex();
        this.hLength = 0;
        c.writeShort((int)this.hLength);
        ListIterator<PcepValueType> listIterator = this.llLinkAttributesSubTLVs.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = listIterator.next();
            if (tlv == null) {
                log.debug("TLV is null from subTlv list");
                continue;
            }
            tlv.write(c);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                c.writeByte(0);
            }
        }
        this.hLength = (short)(c.writerIndex() - tlvStartIndex);
        c.setShort(tlvLenIndex, this.hLength - 4);
        return c.writerIndex() - tlvStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short hLength) throws PcepParseException {
        LinkedList<PcepValueType> llLinkAttributesSubTLVs = new LinkedList<PcepValueType>();
        ChannelBuffer tempCb = c.readBytes((int)hLength);
        while (4 <= tempCb.readableBytes()) {
            PcepValueType tlv;
            short hType = tempCb.readShort();
            int iValue = 0;
            short length = tempCb.readShort();
            switch (hType) {
                case 17: {
                    iValue = tempCb.readInt();
                    tlv = new IPv4RouterIdOfLocalNodeSubTlv(iValue);
                    break;
                }
                case 18: {
                    byte[] ipv6LValue = new byte[18];
                    tempCb.readBytes(ipv6LValue, 0, 18);
                    tlv = new IPv6RouterIdofLocalNodeSubTlv(ipv6LValue);
                    break;
                }
                case 19: {
                    iValue = tempCb.readInt();
                    tlv = new IPv4RouterIdOfRemoteNodeSubTlv(iValue);
                    break;
                }
                case 20: {
                    byte[] ipv6RValue = new byte[18];
                    tempCb.readBytes(ipv6RValue, 0, 18);
                    tlv = new IPv6RouterIdofRemoteNodeSubTlv(ipv6RValue);
                    break;
                }
                case 6: {
                    tlv = LinkLocalRemoteIdentifiersSubTlv.read(tempCb);
                    break;
                }
                case 22: {
                    iValue = tempCb.readInt();
                    tlv = new AdministrativeGroupSubTlv(iValue);
                    break;
                }
                case 23: {
                    iValue = tempCb.readInt();
                    tlv = new MaximumLinkBandwidthSubTlv(iValue);
                    break;
                }
                case 24: {
                    iValue = tempCb.readInt();
                    tlv = new MaximumReservableLinkBandwidthSubTlv(iValue);
                    break;
                }
                case 25: {
                    iValue = tempCb.readInt();
                    tlv = new UnreservedBandwidthSubTlv(iValue);
                    break;
                }
                case 26: {
                    iValue = tempCb.readInt();
                    tlv = new TEDefaultMetricSubTlv(iValue);
                    break;
                }
                case 27: {
                    tlv = LinkProtectionTypeSubTlv.read(tempCb);
                    break;
                }
                case 28: {
                    byte cValue = tempCb.readByte();
                    tlv = new MplsProtocolMaskSubTlv(cValue);
                    break;
                }
                case 29: {
                    tlv = IgpMetricSubTlv.read(tempCb, length);
                    break;
                }
                case 30: {
                    tlv = SharedRiskLinkGroupSubTlv.read(tempCb, length);
                    break;
                }
                case 31: {
                    tlv = OpaqueLinkAttributeSubTlv.read(tempCb, length);
                    break;
                }
                case 32: {
                    tlv = LinkNameAttributeSubTlv.read(tempCb, length);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported Sub TLV type :" + hType);
                }
            }
            int pad = length % 4;
            if (0 < pad && (pad = 4 - pad) <= tempCb.readableBytes()) {
                tempCb.skipBytes(pad);
            }
            llLinkAttributesSubTLVs.add(tlv);
        }
        if (0 < tempCb.readableBytes()) {
            throw new PcepParseException("Sub Tlv parsing error. Extra bytes received.");
        }
        return new LinkAttributesTlv(llLinkAttributesSubTLVs);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", -250).add("Length", (int)this.hLength).add("LinkAttributesSubTLVs", this.llLinkAttributesSubTLVs).toString();
    }
}

