/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelSubObject
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(LabelSubObject.class);
    public static final short TYPE = 3;
    public static final short LENGTH = 8;
    private final byte flags;
    private final byte cType;
    private final int contents;

    public LabelSubObject(byte flags, byte cType, int contents) {
        this.flags = flags;
        this.cType = cType;
        this.contents = contents;
    }

    public static LabelSubObject of(byte flags, byte cType, int contents) {
        return new LabelSubObject(flags, cType, contents);
    }

    public byte getFlags() {
        return this.flags;
    }

    public byte getCtype() {
        return this.cType;
    }

    public int getContents() {
        return this.contents;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public short getLength() {
        return 8;
    }

    public int hashCode() {
        return Objects.hash(this.flags, this.cType, this.contents);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LabelSubObject) {
            LabelSubObject other = (LabelSubObject)obj;
            return Objects.equals(this.flags, other.flags) && Objects.equals(this.cType, other.cType) && Objects.equals(this.contents, other.contents);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iStartIndex = c.writerIndex();
        c.writeShort(3);
        c.writeShort(8);
        c.writeByte((int)this.flags);
        c.writeByte((int)this.cType);
        c.writeByte(this.contents);
        return c.writerIndex() - iStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c) {
        byte flags = c.readByte();
        byte cType = c.readByte();
        int contents = c.readInt();
        return new LabelSubObject(flags, cType, contents);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", 3).add("Length", 8).add("flags", (int)this.flags).add("C-type", (int)this.cType).add("contents", this.contents).toString();
    }
}

