/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisAreaIdentifierSubTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(IsisAreaIdentifierSubTlv.class);
    public static final short TYPE = 16;
    private short hLength;
    private final byte[] rawValue;

    public IsisAreaIdentifierSubTlv(byte[] rawValue, short hLength) {
        log.debug("ISISAreaIdentifierTlv");
        this.rawValue = rawValue;
        this.hLength = 0 == hLength ? (short)rawValue.length : hLength;
    }

    public static IsisAreaIdentifierSubTlv of(byte[] raw, short hLength) {
        return new IsisAreaIdentifierSubTlv(raw, hLength);
    }

    public byte[] getValue() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 16;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.rawValue), this.rawValue.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IsisAreaIdentifierSubTlv) {
            IsisAreaIdentifierSubTlv other = (IsisAreaIdentifierSubTlv)obj;
            return Objects.equals(this.hLength, other.hLength) && Arrays.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(16);
        c.writeShort((int)this.hLength);
        c.writeBytes(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short hLength) {
        byte[] iIsisAreaIdentifier = new byte[hLength];
        c.readBytes(iIsisAreaIdentifier, 0, (int)hLength);
        return new IsisAreaIdentifierSubTlv(iIsisAreaIdentifier, hLength);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper(this.getClass());
        toStrHelper.add("Type", 16);
        toStrHelper.add("Length", (int)this.hLength);
        StringBuffer result = new StringBuffer();
        for (byte b : this.rawValue) {
            result.append(String.format("%02X ", b));
        }
        toStrHelper.add("Value", (Object)result);
        return toStrHelper.toString();
    }
}

