/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepErrorObject;
import org.onosproject.pcepio.protocol.PcepOpenObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorObjListWithOpen {
    private List<PcepErrorObject> llerrorObjList;
    private PcepOpenObject openObject;
    private boolean isOpenObjectSet;
    protected static final Logger log = LoggerFactory.getLogger(ErrorObjListWithOpen.class);

    public ErrorObjListWithOpen(List<PcepErrorObject> errObj, PcepOpenObject openObj) {
        this.llerrorObjList = errObj;
        this.openObject = openObj;
        this.isOpenObjectSet = openObj != null;
    }

    public ErrorObjListWithOpen(List<PcepErrorObject> errObj) {
        this.llerrorObjList = errObj;
        this.openObject = null;
        this.isOpenObjectSet = false;
    }

    public List<Integer> getErrorType() {
        LinkedList<Integer> errorType = new LinkedList<Integer>();
        if (this.llerrorObjList != null) {
            ListIterator<PcepErrorObject> errObjListIterator = this.llerrorObjList.listIterator();
            while (errObjListIterator.hasNext()) {
                PcepErrorObject errorObj = errObjListIterator.next();
                int error = errorObj.getErrorType();
                errorType.add(error);
            }
        }
        return errorType;
    }

    public List<Integer> getErrorValue() {
        LinkedList<Integer> errorValue = new LinkedList<Integer>();
        if (this.llerrorObjList != null) {
            ListIterator<PcepErrorObject> errObjListIterator = this.llerrorObjList.listIterator();
            while (errObjListIterator.hasNext()) {
                PcepErrorObject errorObj = errObjListIterator.next();
                byte error = errorObj.getErrorValue();
                errorValue.add(Integer.valueOf(error));
            }
        }
        return errorValue;
    }

    public boolean isErrorObjListWithOpenPresent() {
        return !this.llerrorObjList.isEmpty();
    }

    public int write(ChannelBuffer cb) throws PcepParseException {
        int iLenStartIndex = cb.writerIndex();
        boolean bIsErrObjListFound = false;
        if (this.llerrorObjList != null) {
            ListIterator<PcepErrorObject> errObjListIterator = this.llerrorObjList.listIterator();
            while (errObjListIterator.hasNext()) {
                errObjListIterator.next().write(cb);
                bIsErrObjListFound = true;
            }
        }
        if (!bIsErrObjListFound) {
            throw new PcepParseException("<error-obj-list> is mandatory.");
        }
        if (this.openObject != null) {
            this.openObject.write(cb);
        }
        return cb.writerIndex() - iLenStartIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("ErrorObjList", this.llerrorObjList).add("Open", (Object)this.openObject).toString();
    }
}

