/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutonomousSystemSubTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(AutonomousSystemSubTlv.class);
    public static final short TYPE = 1;
    public static final short LENGTH = 4;
    private final int rawValue;

    public AutonomousSystemSubTlv(int rawValue) {
        this.rawValue = rawValue;
    }

    public static AutonomousSystemSubTlv of(int raw) {
        return new AutonomousSystemSubTlv(raw);
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 1;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        return Objects.hash(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AutonomousSystemSubTlv) {
            AutonomousSystemSubTlv other = (AutonomousSystemSubTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(1);
        c.writeShort(4);
        c.writeInt(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static AutonomousSystemSubTlv read(ChannelBuffer c) {
        return AutonomousSystemSubTlv.of(c.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("TYPE", 1).add("Length", 4).add("value", this.rawValue).toString();
    }
}

