/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutonomousSystemNumberSubObject
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(AutonomousSystemNumberSubObject.class);
    public static final byte TYPE = 50;
    public static final byte LENGTH = 4;
    public static final byte VALUE_LENGTH = 2;
    public static final byte OBJ_LENGTH = 4;
    public static final byte LBIT = 0;
    public static final int SHIFT_LBIT_POSITION = 7;
    private short asNumber;

    public AutonomousSystemNumberSubObject(short asNumber) {
        this.asNumber = asNumber;
    }

    public static AutonomousSystemNumberSubObject of(short asNumber) {
        return new AutonomousSystemNumberSubObject(asNumber);
    }

    public short getAsNumber() {
        return this.asNumber;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 50;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        return Objects.hash(this.asNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AutonomousSystemNumberSubObject) {
            AutonomousSystemNumberSubObject other = (AutonomousSystemNumberSubObject)obj;
            return Objects.equals(this.asNumber, other.asNumber);
        }
        return false;
    }

    public static PcepValueType read(ChannelBuffer c) {
        short asNumber = c.readShort();
        return new AutonomousSystemNumberSubObject(asNumber);
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        int bValue = 0;
        bValue = (byte)(bValue << 7);
        bValue = (byte)(bValue | 0x32);
        c.writeByte(bValue);
        c.writeByte(4);
        c.writeShort((int)this.asNumber);
        return c.writerIndex() - iLenStartIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 50).add("Length", 4).add("AsNumber", (int)this.asNumber).toString();
    }
}

