/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.types.PathSetupTypeTlv;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.SymbolicPathNameTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepSrpObjectVer1
implements PcepSrpObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepSrpObjectVer1.class);
    public static final byte SRP_OBJ_TYPE = 1;
    public static final byte SRP_OBJ_CLASS = 33;
    public static final byte SRP_OBJECT_VERSION = 1;
    public static final short SRP_OBJ_MINIMUM_LENGTH = 12;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    public static final boolean FLAG_DEFAULT_VALUE = false;
    static final PcepObjectHeader DEFAULT_SRP_OBJECT_HEADER = new PcepObjectHeader(33, 1, false, false, 12);
    private PcepObjectHeader srpObjHeader;
    private static int flags;
    private boolean bRFlag;
    private boolean bSFlag;
    private int srpId;
    private LinkedList<PcepValueType> llOptionalTlv;
    public static final byte BBIT_SET = 1;
    public static final byte BBIT_RESET = 0;

    public PcepSrpObjectVer1(PcepObjectHeader srpObjHeader, boolean bRFlag, boolean bSFlag, int srpID, LinkedList<PcepValueType> llOptionalTlv) {
        this.srpObjHeader = srpObjHeader;
        this.bRFlag = bRFlag;
        this.bSFlag = bSFlag;
        this.srpId = srpID;
        this.llOptionalTlv = llOptionalTlv;
    }

    public void setSrpObjHeader(PcepObjectHeader obj) {
        this.srpObjHeader = obj;
    }

    @Override
    public void setSrpID(int srpID) {
        this.srpId = srpID;
    }

    @Override
    public void setRFlag(boolean bRFlag) {
        this.bRFlag = bRFlag;
    }

    @Override
    public void setSFlag(boolean bSFlag) {
        this.bSFlag = bSFlag;
    }

    public PcepObjectHeader getSrpObjHeader() {
        return this.srpObjHeader;
    }

    @Override
    public int getSrpID() {
        return this.srpId;
    }

    @Override
    public boolean getRFlag() {
        return this.bRFlag;
    }

    @Override
    public boolean getSFlag() {
        return this.bSFlag;
    }

    @Override
    public void setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
        this.llOptionalTlv = llOptionalTlv;
    }

    @Override
    public LinkedList<PcepValueType> getOptionalTlv() {
        return this.llOptionalTlv;
    }

    public static PcepSrpObject read(ChannelBuffer cb) throws PcepParseException {
        log.debug("SrpObject::read");
        LinkedList<PcepValueType> llOptionalTlv = new LinkedList();
        PcepObjectHeader srpObjHeader = PcepObjectHeader.read(cb);
        if (srpObjHeader.getObjClass() != 33) {
            throw new PcepParseException("SRP object expected. But received " + srpObjHeader.getObjClass());
        }
        ChannelBuffer tempCb = cb.readBytes(srpObjHeader.getObjLen() - 4);
        int flags = tempCb.readInt();
        boolean bRFlag = 0 < (flags & 1);
        boolean bSFlag = 0 < (flags >> 1 & 1);
        int srpID = tempCb.readInt();
        llOptionalTlv = PcepSrpObjectVer1.parseOptionalTlv(tempCb);
        return new PcepSrpObjectVer1(srpObjHeader, bRFlag, bSFlag, srpID, llOptionalTlv);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.srpObjHeader.write(cb);
        int bFlag = this.bRFlag ? 1 : 0;
        bFlag = (byte)(bFlag | (this.bSFlag ? 1 : 0) << 1);
        cb.writeInt(bFlag);
        cb.writeInt(this.srpId);
        if (!this.packOptionalTlv(cb)) {
            throw new PcepParseException("Failed to write srp tlv to channel buffer.");
        }
        cb.setShort(objLenIndex, (int)((short)(cb.writerIndex() - objStartIndex)));
        return cb.writerIndex();
    }

    public static LinkedList<PcepValueType> parseOptionalTlv(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOutOptionalTlv = new LinkedList<PcepValueType>();
        while (4 <= cb.readableBytes()) {
            PcepValueType tlv;
            short hType = cb.readShort();
            short hLength = cb.readShort();
            switch (hType) {
                case 17: {
                    if (cb.readableBytes() < hLength) {
                        throw new PcepParseException("Length is not valid in SymbolicPathNameTlv");
                    }
                    tlv = SymbolicPathNameTlv.read(cb, hLength);
                    break;
                }
                case 28: {
                    if (cb.readableBytes() != 4) {
                        throw new PcepParseException("Length is not valid in PathSetupTypeTlv");
                    }
                    tlv = PathSetupTypeTlv.of(cb.readInt());
                    break;
                }
                default: {
                    cb.skipBytes((int)hLength);
                    tlv = null;
                    log.info("Received unsupported TLV type :" + hType + " in SRP object.");
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= cb.readableBytes()) {
                cb.skipBytes(pad);
            }
            if (tlv == null) continue;
            llOutOptionalTlv.add(tlv);
        }
        return llOutOptionalTlv;
    }

    protected boolean packOptionalTlv(ChannelBuffer cb) {
        ListIterator listIterator = this.llOptionalTlv.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            if (tlv == null) {
                log.debug("tlv is null from OptionalTlv list");
                continue;
            }
            tlv.write(cb);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
        }
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("RFlag", this.bRFlag).add("SFlag", this.bSFlag).add("SRPID", this.srpId).add("OptionalTlvList", this.llOptionalTlv).toString();
    }

    public static class Builder
    implements PcepSrpObject.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsSrpIdset = false;
        private boolean bIsRFlagSet = false;
        private boolean bIsSFlagSet = false;
        private PcepObjectHeader srpObjHeader;
        private int srpId;
        private boolean bRFlag;
        private boolean bSFlag;
        LinkedList<PcepValueType> llOptionalTlv = new LinkedList();
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepSrpObject build() throws PcepParseException {
            boolean bSFlag;
            PcepObjectHeader srpObjHeader = this.bIsHeaderSet ? this.srpObjHeader : DEFAULT_SRP_OBJECT_HEADER;
            boolean bRFlag = this.bIsRFlagSet ? this.bRFlag : false;
            boolean bl = bSFlag = this.bIsSFlagSet ? this.bSFlag : false;
            if (!this.bIsSrpIdset) {
                throw new PcepParseException("SrpID not set while building SRP Object.");
            }
            if (this.bIsPFlagSet) {
                srpObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                srpObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepSrpObjectVer1(srpObjHeader, bRFlag, bSFlag, this.srpId, this.llOptionalTlv);
        }

        @Override
        public PcepObjectHeader getSrpObjHeader() {
            return this.srpObjHeader;
        }

        @Override
        public Builder setSrpObjHeader(PcepObjectHeader obj) {
            this.srpObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public int getSrpID() {
            return this.srpId;
        }

        @Override
        public Builder setSrpID(int srpID) {
            this.srpId = srpID;
            this.bIsSrpIdset = true;
            return this;
        }

        @Override
        public boolean getRFlag() {
            return this.bRFlag;
        }

        @Override
        public Builder setRFlag(boolean bRFlag) {
            this.bRFlag = bRFlag;
            this.bIsRFlagSet = true;
            return this;
        }

        @Override
        public boolean getSFlag() {
            return this.bSFlag;
        }

        @Override
        public Builder setSFlag(boolean bSFlag) {
            this.bSFlag = bSFlag;
            this.bIsSFlagSet = true;
            return this;
        }

        @Override
        public Builder setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
            this.llOptionalTlv = llOptionalTlv;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getOptionalTlv() {
            return this.llOptionalTlv;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

