/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepRroObject;
import org.onosproject.pcepio.types.IPv4SubObject;
import org.onosproject.pcepio.types.IPv6SubObject;
import org.onosproject.pcepio.types.LabelSubObject;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepRroObjectVer1
implements PcepRroObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepRroObjectVer1.class);
    public static final byte RRO_OBJ_TYPE = 1;
    public static final byte RRO_OBJ_CLASS = 8;
    public static final byte RRO_OBJECT_VERSION = 1;
    public static final short RRO_OBJ_MINIMUM_LENGTH = 12;
    public static final int OBJECT_HEADER_LENGTH = 4;
    public static final int YTYPE_SHIFT_VALUE = 127;
    static final PcepObjectHeader DEFAULT_RRO_OBJECT_HEADER = new PcepObjectHeader(8, 1, false, false, 12);
    private short rroObjType = 0;
    private byte length;
    private byte prefixLength;
    private byte resvd;
    PcepObjectHeader rroObjHeader;
    private LinkedList<PcepValueType> llSubObjects = new LinkedList();

    public PcepRroObjectVer1() {
        this.rroObjHeader = null;
        this.rroObjType = 0;
        this.length = 0;
    }

    public PcepRroObjectVer1(PcepObjectHeader rroObjHeader, LinkedList<PcepValueType> llSubObjects) {
        this.rroObjHeader = rroObjHeader;
        this.llSubObjects = llSubObjects;
    }

    public PcepObjectHeader getRroObjHeader() {
        return this.rroObjHeader;
    }

    public void setRroObjHeader(PcepObjectHeader obj) {
        this.rroObjHeader = obj;
    }

    @Override
    public LinkedList<PcepValueType> getSubObjects() {
        return this.llSubObjects;
    }

    @Override
    public void setSubObjects(LinkedList<PcepValueType> llSubObjects) {
        this.llSubObjects = llSubObjects;
    }

    public static PcepRroObject read(ChannelBuffer cb) throws PcepParseException {
        PcepObjectHeader rroObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(rroObjHeader.getObjLen() - 4);
        LinkedList<PcepValueType> llSubObjects = PcepRroObjectVer1.parseSubObjects(tempCb);
        return new PcepRroObjectVer1(rroObjHeader, llSubObjects);
    }

    protected static LinkedList<PcepValueType> parseSubObjects(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llSubObjects = new LinkedList<PcepValueType>();
        while (0 < cb.readableBytes()) {
            PcepValueType subObj;
            byte yType = cb.readByte();
            yType = (byte)(yType & 0x7F);
            byte hLength = cb.readByte();
            switch (yType) {
                case 1: {
                    subObj = IPv4SubObject.read(cb);
                    break;
                }
                case 2: {
                    byte[] ipv6Value = new byte[18];
                    cb.readBytes(ipv6Value, 0, 18);
                    subObj = new IPv6SubObject(ipv6Value);
                    break;
                }
                case 3: {
                    subObj = LabelSubObject.read(cb);
                    break;
                }
                default: {
                    throw new PcepParseException(" Unexpected sub object. Type: " + yType);
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= cb.readableBytes()) {
                cb.skipBytes(pad);
            }
            llSubObjects.add(subObj);
        }
        return llSubObjects;
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.rroObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException(" object Length Index" + objLenIndex);
        }
        ListIterator listIterator = this.llSubObjects.listIterator();
        while (listIterator.hasNext()) {
            ((PcepValueType)listIterator.next()).write(cb);
        }
        int length = cb.writerIndex() - objStartIndex;
        cb.setShort(objLenIndex, (int)((short)length));
        this.rroObjHeader.setObjLen((short)length);
        int pad = length % 4;
        if (0 != pad) {
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
        }
        objLenIndex = cb.writerIndex();
        return objLenIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("SubObjects", this.llSubObjects).toString();
    }

    public static class Builder
    implements PcepRroObject.Builder {
        private boolean bIsHeaderSet = false;
        private PcepObjectHeader rroObjHeader;
        LinkedList<PcepValueType> llSubObjects = new LinkedList();
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepRroObject build() {
            PcepObjectHeader rroObjHeader;
            PcepObjectHeader pcepObjectHeader = rroObjHeader = this.bIsHeaderSet ? this.rroObjHeader : DEFAULT_RRO_OBJECT_HEADER;
            if (this.bIsPFlagSet) {
                rroObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                rroObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepRroObjectVer1(rroObjHeader, this.llSubObjects);
        }

        @Override
        public PcepObjectHeader getRroObjHeader() {
            return this.rroObjHeader;
        }

        @Override
        public Builder setRroObjHeader(PcepObjectHeader obj) {
            this.rroObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getSubObjects() {
            return this.llSubObjects;
        }

        @Override
        public Builder setSubObjects(LinkedList<PcepValueType> llSubObjects) {
            this.llSubObjects = llSubObjects;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

