/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepMessageWriter;
import org.onosproject.pcepio.protocol.PcepReportMsg;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.protocol.PcepStateReport;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.protocol.ver1.PcepLspObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepSrpObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepStateReportVer1;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PcepReportMsgVer1
implements PcepReportMsg {
    protected static final Logger log = LoggerFactory.getLogger(PcepReportMsgVer1.class);
    public static final byte PACKET_VERSION = 1;
    public static final int PACKET_MINIMUM_LENGTH = 12;
    public static final PcepType MSG_TYPE = PcepType.REPORT;
    public static final byte REPORT_OBJ_TYPE = 1;
    private LinkedList<PcepStateReport> llStateReportList;
    public static final Reader READER = new Reader();
    static final Writer WRITER = new Writer();

    PcepReportMsgVer1(LinkedList<PcepStateReport> llStateReportList) {
        this.llStateReportList = llStateReportList;
    }

    @Override
    public void writeTo(ChannelBuffer cb) throws PcepParseException {
        WRITER.write(cb, this);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public PcepType getType() {
        return MSG_TYPE;
    }

    @Override
    public LinkedList<PcepStateReport> getStateReportList() {
        return this.llStateReportList;
    }

    @Override
    public void setStateReportList(LinkedList<PcepStateReport> ll) {
        this.llStateReportList = ll;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("StateReportList", this.llStateReportList).toString();
    }

    static class Writer
    implements PcepMessageWriter<PcepReportMsgVer1> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer cb, PcepReportMsgVer1 message) throws PcepParseException {
            int startIndex = cb.writerIndex();
            cb.writeByte(32);
            cb.writeByte((int)MSG_TYPE.getType());
            int msgLenIndex = cb.writerIndex();
            cb.writeShort(0);
            ListIterator listIterator = message.llStateReportList.listIterator();
            while (listIterator.hasNext()) {
                PcepLspObject lspObj;
                PcepStateReport stateRpt = (PcepStateReport)listIterator.next();
                PcepSrpObject srpObj = stateRpt.getSrpObject();
                if (srpObj != null) {
                    srpObj.write(cb);
                }
                if ((lspObj = stateRpt.getLspObject()) == null) {
                    throw new PcepParseException("LSP Object is mandatory object for PcRpt message.");
                }
                lspObj.write(cb);
                PcepStateReport.PcepMsgPath msgPath = stateRpt.getMsgPath();
                if (msgPath == null) {
                    throw new PcepParseException("Message path is mandatory object for PcRpt message.");
                }
                msgPath.write(cb);
            }
            int length = cb.writerIndex() - startIndex;
            cb.setShort(msgLenIndex, (int)((short)length));
        }
    }

    static class Builder
    implements PcepReportMsg.Builder {
        LinkedList<PcepStateReport> llStateReportList;

        Builder() {
        }

        @Override
        public PcepVersion getVersion() {
            return PcepVersion.PCEP_1;
        }

        @Override
        public PcepType getType() {
            return PcepType.REPORT;
        }

        @Override
        public PcepReportMsg build() {
            return new PcepReportMsgVer1(this.llStateReportList);
        }

        @Override
        public LinkedList<PcepStateReport> getStateReportList() {
            return this.llStateReportList;
        }

        @Override
        public Builder setStateReportList(LinkedList<PcepStateReport> ll) {
            this.llStateReportList = ll;
            return this;
        }
    }

    static class Reader
    implements PcepMessageReader<PcepReportMsg> {
        LinkedList<PcepStateReport> llStateReportList;

        Reader() {
        }

        @Override
        public PcepReportMsg readFrom(ChannelBuffer cb) throws PcepParseException {
            if (cb.readableBytes() < 12) {
                throw new PcepParseException("Received packet size " + cb.readableBytes() + " is less than the expected size: " + 12);
            }
            this.llStateReportList = new LinkedList();
            byte version = cb.readByte();
            if ((version = (byte)(version >> 5)) != 1) {
                throw new PcepParseException(" Invalid version: " + version);
            }
            byte type = cb.readByte();
            if (type != MSG_TYPE.getType()) {
                throw new PcepParseException("Unexpected type: " + type);
            }
            short length = cb.readShort();
            if (length < 12) {
                throw new PcepParseException("Wrong length. Expected to be >= 12, was: " + length);
            }
            this.parseStateReportList(cb);
            return new PcepReportMsgVer1(this.llStateReportList);
        }

        public void parseStateReportList(ChannelBuffer cb) throws PcepParseException {
            while (0 < cb.readableBytes()) {
                PcepStateReportVer1 pcestateReq = new PcepStateReportVer1();
                cb.markReaderIndex();
                PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
                byte yObjectClass = tempObjHeader.getObjClass();
                byte yObjectType = tempObjHeader.getObjType();
                cb.resetReaderIndex();
                if (33 == yObjectClass && 1 == yObjectType) {
                    PcepSrpObject srpObj = PcepSrpObjectVer1.read(cb);
                    pcestateReq.setSrpObject(srpObj);
                }
                PcepLspObject lspObj = PcepLspObjectVer1.read(cb);
                pcestateReq.setLspObject(lspObj);
                if (cb.readableBytes() > 0) {
                    cb.markReaderIndex();
                    tempObjHeader = PcepObjectHeader.read(cb);
                    yObjectClass = tempObjHeader.getObjClass();
                    yObjectType = tempObjHeader.getObjType();
                    cb.resetReaderIndex();
                    if (7 == yObjectClass && 1 == yObjectType) {
                        PcepStateReportVer1.PcepMsgPath msgPath = new PcepStateReportVer1.PcepMsgPath(new PcepStateReportVer1()).read(cb);
                        pcestateReq.setMsgPath(msgPath);
                    }
                }
                this.llStateReportList.add(pcestateReq);
            }
        }
    }
}

