/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepMetricObject;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepMetricObjectVer1
implements PcepMetricObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepMetricObjectVer1.class);
    public static final byte METRIC_OBJ_TYPE = 1;
    public static final byte METRIC_OBJ_CLASS = 6;
    public static final byte METRIC_OBJECT_VERSION = 1;
    public static final short METRIC_OBJ_MINIMUM_LENGTH = 12;
    public static final int OBJECT_HEADER_LENGTH = 4;
    public static final int IFLAG_SHIFT_VALUE = 9;
    public static final int BTYPE_SHIFT_VALUE = 8;
    public static final int CFLAG_SET = 1;
    public static final int CFLAG_RESET = 0;
    public static final int BFLAG_SET = 1;
    public static final int BFLAG_RESET = 0;
    public static final byte CFLAG_CHECK = 2;
    public static final byte IGP_METRIC = 1;
    public static final byte TE_METRIC = 2;
    public static final byte HOP_COUNT_METRIC = 3;
    static final PcepObjectHeader DEFAULT_METRIC_OBJECT_HEADER = new PcepObjectHeader(6, 1, false, false, 12);
    private PcepObjectHeader metricObjHeader;
    private int iMetricVal;
    private byte yFlag;
    private boolean bCFlag;
    private boolean bBFlag;
    private byte bType;

    public PcepMetricObjectVer1() {
        this.metricObjHeader = null;
        this.iMetricVal = 0;
        this.yFlag = 0;
        this.bCFlag = false;
        this.bBFlag = false;
        this.bType = 0;
    }

    public PcepMetricObjectVer1(PcepObjectHeader metricObjHeader, int iMetricVal, byte yFlag, boolean bCFlag, boolean bBFlag, byte bType) {
        this.metricObjHeader = metricObjHeader;
        this.iMetricVal = iMetricVal;
        this.yFlag = yFlag;
        this.bCFlag = bCFlag;
        this.bBFlag = bBFlag;
        this.bType = bType;
    }

    @Override
    public void setMetricVal(int value) {
        this.iMetricVal = value;
    }

    @Override
    public int getMetricVal() {
        return this.iMetricVal;
    }

    @Override
    public byte getYFlag() {
        return this.yFlag;
    }

    @Override
    public void setYFlag(byte value) {
        this.yFlag = value;
    }

    @Override
    public boolean getCFlag() {
        return this.bCFlag;
    }

    @Override
    public void setCFlag(boolean value) {
        this.bCFlag = value;
    }

    @Override
    public boolean getBFlag() {
        return this.bBFlag;
    }

    @Override
    public void setBFlag(boolean value) {
        this.bBFlag = value;
    }

    @Override
    public byte getBType() {
        return this.bType;
    }

    @Override
    public void setBType(byte value) {
        this.bType = value;
    }

    public void setMetricObjHeader(PcepObjectHeader obj) {
        this.metricObjHeader = obj;
    }

    public PcepObjectHeader getMetricObjHeader() {
        return this.metricObjHeader;
    }

    public static PcepMetricObject read(ChannelBuffer cb) throws PcepParseException {
        log.debug("MetricObject::read");
        PcepObjectHeader metricObjHeader = PcepObjectHeader.read(cb);
        if (metricObjHeader.getObjClass() != 6) {
            throw new PcepParseException("This object is not a Metric Object. Object Class: " + metricObjHeader.getObjClass());
        }
        ChannelBuffer tempCb = cb.readBytes(metricObjHeader.getObjLen() - 4);
        tempCb.readShort();
        byte yFlag = tempCb.readByte();
        byte bType = tempCb.readByte();
        boolean bCFlag = (yFlag & 2) == 2;
        boolean bBFlag = (yFlag & 1) == 1;
        int iMetricVal = tempCb.readInt();
        return new PcepMetricObjectVer1(metricObjHeader, iMetricVal, yFlag, bCFlag, bBFlag, bType);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.metricObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException("Error: ObjectLength is " + objLenIndex);
        }
        int iFlag = this.bCFlag ? 1 : 0;
        int iTemp = iFlag << 9;
        iFlag = this.bBFlag ? 1 : 0;
        iTemp |= iFlag << 8;
        cb.writeInt(iTemp |= this.bType);
        cb.writeInt(this.iMetricVal);
        short hLength = (short)(cb.writerIndex() - objStartIndex);
        cb.setShort(objLenIndex, (int)hLength);
        this.metricObjHeader.setObjLen(hLength);
        return hLength;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("MetricValue", this.iMetricVal).add("BFlag", this.bBFlag).add("CFlag", this.bCFlag).add("BType", (int)this.bType).toString();
    }

    public static class Builder
    implements PcepMetricObject.Builder {
        private boolean bIsHeaderSet = false;
        private PcepObjectHeader metricObjHeader;
        private int iMetricVal;
        private boolean bIsMetricValSet = false;
        private byte yFlag;
        private boolean bCFlag;
        private boolean bBFlag;
        private byte bType;
        private boolean bIsbTypeSet = false;
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepMetricObject build() throws PcepParseException {
            PcepObjectHeader metricObjHeader;
            PcepObjectHeader pcepObjectHeader = metricObjHeader = this.bIsHeaderSet ? this.metricObjHeader : DEFAULT_METRIC_OBJECT_HEADER;
            if (!this.bIsMetricValSet) {
                throw new PcepParseException(" Metric Value NOT Set while building PcepMetricObject.");
            }
            if (!this.bIsbTypeSet) {
                throw new PcepParseException(" Type NOT Set while building PcepMetricObject.");
            }
            if (this.bIsPFlagSet) {
                metricObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                metricObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepMetricObjectVer1(metricObjHeader, this.iMetricVal, this.yFlag, this.bCFlag, this.bBFlag, this.bType);
        }

        @Override
        public PcepObjectHeader getMetricObjHeader() {
            return this.metricObjHeader;
        }

        @Override
        public Builder setMetricObjHeader(PcepObjectHeader obj) {
            this.metricObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public int getMetricVal() {
            return this.iMetricVal;
        }

        @Override
        public Builder setMetricVal(int value) {
            this.iMetricVal = value;
            this.bIsMetricValSet = true;
            return this;
        }

        @Override
        public byte getYFlag() {
            return this.yFlag;
        }

        @Override
        public Builder setYFlag(byte value) {
            this.yFlag = value;
            return this;
        }

        @Override
        public boolean getCFlag() {
            return this.bCFlag;
        }

        @Override
        public Builder setCFlag(boolean value) {
            this.bCFlag = value;
            return this;
        }

        @Override
        public boolean getBFlag() {
            return this.bBFlag;
        }

        @Override
        public Builder setBFlag(boolean value) {
            this.bBFlag = value;
            return this;
        }

        @Override
        public byte getBType() {
            return this.bType;
        }

        @Override
        public Builder setBType(byte value) {
            this.bType = value;
            this.bIsbTypeSet = true;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

