/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepOutOfBoundMessageException;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFactories;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.ver1.PcepCloseMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepErrorMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepInitiateMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepKeepaliveMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepLSReportMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepLabelRangeResvMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepLabelUpdateMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepOpenMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepReportMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepUpdateMsgVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PcepMessageVer1 {
    protected static final Logger log = LoggerFactory.getLogger(PcepFactories.class);
    public static final byte WIRE_VERSION = 1;
    public static final int MINIMUM_LENGTH = 4;
    public static final int PACKET_VERSION = 1;
    public static final int SHIFT_FLAG = 5;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    public static final Reader READER = new Reader();

    static class Reader
    implements PcepMessageReader<PcepMessage> {
        Reader() {
        }

        @Override
        public PcepMessage readFrom(ChannelBuffer cb) throws PcepParseException, PcepOutOfBoundMessageException {
            if (cb.readableBytes() < 4) {
                throw new PcepParseException("Packet should have minimum length: 4");
            }
            try {
                int start = cb.readerIndex();
                byte version = cb.readByte();
                version = (byte)(version >> 5);
                if (version != 1) {
                    throw new PcepParseException("Wrong version. Expected=PcepVersion.Message_1(1), got=" + version);
                }
                byte type = cb.readByte();
                short length = cb.readShort();
                cb.readerIndex(start);
                if (length - 4 > cb.readableBytes()) {
                    throw new PcepOutOfBoundMessageException("Message is out-of-bound.");
                }
                if (type == PcepType.OPEN.getType()) {
                    log.debug("OPEN MESSAGE is received");
                    return PcepOpenMsgVer1.READER.readFrom(cb.readBytes((int)length));
                }
                if (type == PcepType.KEEP_ALIVE.getType()) {
                    log.debug("KEEPALIVE MESSAGE is received");
                    return PcepKeepaliveMsgVer1.READER.readFrom(cb.readBytes((int)length));
                }
                if (type == PcepType.ERROR.getType()) {
                    log.debug("ERROR MESSAGE is received");
                    return PcepErrorMsgVer1.READER.readFrom(cb.readBytes((int)length));
                }
                if (type == PcepType.CLOSE.getType()) {
                    log.debug("CLOSE MESSAGE is received");
                    return PcepCloseMsgVer1.READER.readFrom(cb.readBytes((int)length));
                }
                if (type == PcepType.REPORT.getType()) {
                    log.debug("REPORT MESSAGE is received");
                    return PcepReportMsgVer1.READER.readFrom(cb.readBytes((int)length));
                }
                if (type == PcepType.UPDATE.getType()) {
                    log.debug("UPDATE MESSAGE is received");
                    return PcepUpdateMsgVer1.READER.readFrom(cb.readBytes((int)length));
                }
                if (type == PcepType.INITIATE.getType()) {
                    log.debug("INITIATE MESSAGE is received");
                    return PcepInitiateMsgVer1.READER.readFrom(cb.readBytes((int)length));
                }
                if (type == PcepType.LS_REPORT.getType()) {
                    log.debug("LS REPORT MESSAGE is received");
                    return PcepLSReportMsgVer1.READER.readFrom(cb.readBytes((int)length));
                }
                if (type == PcepType.LABEL_RANGE_RESERV.getType()) {
                    log.debug("LABEL RANGE RESERVE MESSAGE is received");
                    return PcepLabelRangeResvMsgVer1.READER.readFrom(cb.readBytes((int)length));
                }
                if (type == PcepType.LABEL_UPDATE.getType()) {
                    log.debug("LABEL UPDATE MESSAGE is received");
                    return PcepLabelUpdateMsgVer1.READER.readFrom(cb.readBytes((int)length));
                }
                throw new PcepParseException("ERROR: UNKNOWN MESSAGE is received. Msg Type: " + type);
            }
            catch (IndexOutOfBoundsException e) {
                throw new PcepParseException(1, 1);
            }
        }
    }
}

