/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFecObject;
import org.onosproject.pcepio.protocol.PcepLabelObject;
import org.onosproject.pcepio.protocol.PcepLabelUpdate;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.protocol.ver1.PcepFecObjectIPv4AdjacencyVer1;
import org.onosproject.pcepio.protocol.ver1.PcepFecObjectIPv4UnnumberedAdjacencyVer1;
import org.onosproject.pcepio.protocol.ver1.PcepFecObjectIPv4Ver1;
import org.onosproject.pcepio.protocol.ver1.PcepFecObjectIPv6AdjacencyVer1;
import org.onosproject.pcepio.protocol.ver1.PcepFecObjectIPv6Ver1;
import org.onosproject.pcepio.protocol.ver1.PcepLabelObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepLspObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepSrpObjectVer1;
import org.onosproject.pcepio.types.PcepLabelDownload;
import org.onosproject.pcepio.types.PcepLabelMap;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepLabelUpdateVer1
implements PcepLabelUpdate {
    protected static final Logger log = LoggerFactory.getLogger(PcepLabelUpdateVer1.class);
    private PcepLabelDownload labelDownload;
    private boolean isLabelDownloadSet;
    private PcepLabelMap labelMap;
    private boolean isLabelMapSet;

    public PcepLabelUpdateVer1() {
        this.labelDownload = null;
        this.isLabelDownloadSet = false;
        this.labelMap = null;
        this.isLabelMapSet = false;
    }

    public PcepLabelUpdateVer1(PcepLabelDownload labelDownload) {
        this.labelDownload = labelDownload;
        this.isLabelDownloadSet = true;
        this.labelMap = null;
        this.isLabelMapSet = false;
    }

    public PcepLabelUpdateVer1(PcepLabelMap labelMap) {
        this.labelDownload = null;
        this.isLabelDownloadSet = false;
        this.labelMap = labelMap;
        this.isLabelMapSet = true;
    }

    public static PcepLabelUpdate read(ChannelBuffer cb) throws PcepParseException {
        PcepLabelUpdateVer1 pceLabelUpdate = new PcepLabelUpdateVer1();
        PcepSrpObject srpObject = PcepSrpObjectVer1.read(cb);
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        if (tempObjHeader.getObjClass() == 32) {
            PcepLabelDownload labelDownload = new PcepLabelDownload();
            labelDownload.setSrpObject(srpObject);
            labelDownload.setLspObject(PcepLspObjectVer1.read(cb));
            LinkedList<PcepLabelObject> llLabelList = new LinkedList<PcepLabelObject>();
            while (0 < cb.readableBytes()) {
                cb.markReaderIndex();
                tempObjHeader = PcepObjectHeader.read(cb);
                cb.resetReaderIndex();
                if (tempObjHeader.getObjClass() != -31) break;
                PcepLabelObject labelObject = PcepLabelObjectVer1.read(cb);
                llLabelList.add(labelObject);
            }
            labelDownload.setLabelList(llLabelList);
            pceLabelUpdate.setLabelDownload(labelDownload);
        } else if (tempObjHeader.getObjClass() == -31) {
            PcepLabelMap labelMap = new PcepLabelMap();
            labelMap.setSrpObject(srpObject);
            labelMap.setLabelObject(PcepLabelObjectVer1.read(cb));
            cb.markReaderIndex();
            tempObjHeader = PcepObjectHeader.read(cb);
            cb.resetReaderIndex();
            PcepFecObject fecObject = null;
            switch (tempObjHeader.getObjType()) {
                case 1: {
                    fecObject = PcepFecObjectIPv4Ver1.read(cb);
                    break;
                }
                case 2: {
                    fecObject = PcepFecObjectIPv6Ver1.read(cb);
                    break;
                }
                case 3: {
                    fecObject = PcepFecObjectIPv4AdjacencyVer1.read(cb);
                    break;
                }
                case 4: {
                    fecObject = PcepFecObjectIPv6AdjacencyVer1.read(cb);
                    break;
                }
                case 5: {
                    fecObject = PcepFecObjectIPv4UnnumberedAdjacencyVer1.read(cb);
                    break;
                }
                default: {
                    throw new PcepParseException("Unkown FEC object type " + tempObjHeader.getObjType());
                }
            }
            labelMap.setFecObject(fecObject);
            pceLabelUpdate.setLabelMap(labelMap);
        } else {
            throw new PcepParseException("Either <pce-label-download> or <pce-label-map> should be present. Received Class: " + tempObjHeader.getObjClass());
        }
        return pceLabelUpdate;
    }

    @Override
    public void write(ChannelBuffer cb) throws PcepParseException {
        if (this.labelDownload != null && this.labelMap != null) {
            throw new PcepParseException("Label Download and Label Map both can't be present.");
        }
        if (this.labelDownload == null && this.labelMap == null) {
            throw new PcepParseException("Either Label Download or Label Map should be present.");
        }
        if (this.labelDownload != null) {
            PcepSrpObject srpObject = this.labelDownload.getSrpObject();
            if (srpObject == null) {
                throw new PcepParseException("SRP Object is mandatory object for Label Download.");
            }
            srpObject.write(cb);
            PcepLspObject lspObject = this.labelDownload.getLspObject();
            if (lspObject == null) {
                throw new PcepParseException("LSP Object is mandatory object for Label Download.");
            }
            lspObject.write(cb);
            LinkedList<PcepLabelObject> llLabelList = this.labelDownload.getLabelList();
            if (llLabelList == null || llLabelList.isEmpty()) {
                throw new PcepParseException("Label list is mandatory object for Label Download.");
            }
            ListIterator listIterator = llLabelList.listIterator();
            while (listIterator.hasNext()) {
                PcepLabelObject labelObject = (PcepLabelObject)listIterator.next();
                labelObject.write(cb);
            }
        }
        if (this.labelMap != null) {
            PcepSrpObject srpObject = this.labelMap.getSrpObject();
            if (srpObject == null) {
                throw new PcepParseException("SRP Object is mandatory object for Label map.");
            }
            srpObject.write(cb);
            PcepLabelObject labelObject = this.labelMap.getLabelObject();
            if (labelObject == null) {
                throw new PcepParseException("label Object is mandatory object for Label map.");
            }
            labelObject.write(cb);
            PcepFecObject fecObject = this.labelMap.getFecObject();
            if (fecObject == null) {
                throw new PcepParseException("fec Object is mandatory object for Label map.");
            }
            fecObject.write(cb);
        }
    }

    @Override
    public void setLabelDownload(PcepLabelDownload labelDownload) {
        if (this.isLabelMapSet) {
            return;
        }
        this.labelDownload = labelDownload;
        this.isLabelDownloadSet = true;
    }

    @Override
    public PcepLabelDownload getLabelDownload() {
        return this.labelDownload;
    }

    @Override
    public void setLabelMap(PcepLabelMap labelMap) {
        if (this.isLabelDownloadSet) {
            return;
        }
        this.labelMap = labelMap;
        this.isLabelMapSet = true;
    }

    @Override
    public PcepLabelMap getLabelMap() {
        return this.labelMap;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("LabelDownload", (Object)this.labelDownload).add("LabelMap", (Object)this.labelMap).toString();
    }

    static class Builder
    implements PcepLabelUpdate.Builder {
        private PcepLabelDownload labelDownload;
        private boolean isLabelDownloadSet;
        private PcepLabelMap labelMap;
        private boolean isLabelMapSet;

        Builder() {
        }

        @Override
        public PcepLabelUpdate build() throws PcepParseException {
            if (this.isLabelDownloadSet) {
                return new PcepLabelUpdateVer1(this.labelDownload);
            }
            if (this.isLabelMapSet) {
                return new PcepLabelUpdateVer1(this.labelMap);
            }
            if (!this.isLabelDownloadSet && !this.isLabelMapSet) {
                throw new PcepParseException("Label Download or Label Map is not set while building PcepLabelUpdate Message");
            }
            return new PcepLabelUpdateVer1();
        }

        @Override
        public Builder setLabelDownload(PcepLabelDownload labelDownload) {
            this.labelDownload = labelDownload;
            this.isLabelDownloadSet = true;
            return this;
        }

        @Override
        public PcepLabelDownload getLabelDownload() {
            return this.labelDownload;
        }

        @Override
        public Builder setLabelMap(PcepLabelMap labelMap) {
            this.labelMap = labelMap;
            this.isLabelMapSet = true;
            return this;
        }

        @Override
        public PcepLabelMap getLabelMap() {
            return this.labelMap;
        }
    }
}

