/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLabelRangeObject;
import org.onosproject.pcepio.types.PathSetupTypeTlv;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepLabelRangeObjectVer1
implements PcepLabelRangeObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepLabelRangeObjectVer1.class);
    public static final byte LABEL_RANGE_OBJ_TYPE = 1;
    public static final byte LABEL_RANGE_OBJ_CLASS = 60;
    public static final byte LABEL_RANGE_OBJECT_VERSION = 1;
    public static final short LABEL_RANGE_OBJ_MINIMUM_LENGTH = 12;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    static final PcepObjectHeader DEFAULT_LABELRANGE_OBJECT_HEADER = new PcepObjectHeader(60, 1, false, false, 12);
    private PcepObjectHeader labelRangeObjHeader;
    private byte labelType;
    private int rangeSize;
    private int labelBase;
    private LinkedList<PcepValueType> llOptionalTlv;

    public PcepLabelRangeObjectVer1(PcepObjectHeader labelRangeObjHeader, byte labelType, int rangeSize, int labelBase, LinkedList<PcepValueType> llOptionalTlv) {
        this.labelRangeObjHeader = labelRangeObjHeader;
        this.labelType = labelType;
        this.rangeSize = rangeSize;
        this.llOptionalTlv = llOptionalTlv;
        this.labelBase = labelBase;
    }

    @Override
    public void setLabelRangeObjHeader(PcepObjectHeader obj) {
        this.labelRangeObjHeader = obj;
    }

    @Override
    public void setLabelType(byte labelType) {
        this.labelType = labelType;
    }

    @Override
    public void setRangeSize(int rangeSize) {
        this.rangeSize = rangeSize;
    }

    @Override
    public void setLabelBase(int labelBase) {
        this.labelBase = labelBase;
    }

    @Override
    public PcepObjectHeader getLabelRangeObjHeader() {
        return this.labelRangeObjHeader;
    }

    @Override
    public byte getLabelType() {
        return this.labelType;
    }

    @Override
    public int getRangeSize() {
        return this.rangeSize;
    }

    @Override
    public int getLabelBase() {
        return this.labelBase;
    }

    public static PcepLabelRangeObject read(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOptionalTlv = new LinkedList();
        PcepObjectHeader labelRangeObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(labelRangeObjHeader.getObjLen() - 4);
        int temp = 0;
        temp = tempCb.readInt();
        int rangeSize = temp & 0xFFFFFF;
        byte labelType = (byte)(temp >> 24);
        int labelBase = tempCb.readInt();
        llOptionalTlv = PcepLabelRangeObjectVer1.parseOptionalTlv(tempCb);
        return new PcepLabelRangeObjectVer1(labelRangeObjHeader, labelType, rangeSize, labelBase, llOptionalTlv);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.labelRangeObjHeader.write(cb);
        int temp = 0;
        temp = this.labelType;
        temp <<= 24;
        cb.writeInt(temp |= this.rangeSize);
        if (!this.packOptionalTlv(cb)) {
            throw new PcepParseException("Error while writing Optional tlv.");
        }
        cb.setShort(objLenIndex, (int)((short)(cb.writerIndex() - objStartIndex)));
        return cb.writerIndex() - objStartIndex;
    }

    public static LinkedList<PcepValueType> parseOptionalTlv(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOutOptionalTlv = new LinkedList<PcepValueType>();
        while (4 <= cb.readableBytes()) {
            PathSetupTypeTlv tlv;
            short hType = cb.readShort();
            short hLength = cb.readShort();
            switch (hType) {
                case 28: {
                    int iValue = cb.readInt();
                    tlv = new PathSetupTypeTlv(iValue);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported TLV in LabelRange Object.");
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= cb.readableBytes()) {
                cb.skipBytes(pad);
            }
            llOutOptionalTlv.add(tlv);
        }
        return llOutOptionalTlv;
    }

    protected boolean packOptionalTlv(ChannelBuffer cb) {
        ListIterator listIterator = this.llOptionalTlv.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            if (tlv == null) {
                log.debug("tlv is null from OptionalTlv list");
                continue;
            }
            tlv.write(cb);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
        }
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("LabelType", (int)this.labelType).add("rangeSize", this.rangeSize).add("labelBase", this.labelBase).add("optionalTlvList", this.llOptionalTlv).toString();
    }

    public static class Builder
    implements PcepLabelRangeObject.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsLabelType = false;
        private boolean bIsRangeSize = false;
        private boolean bIsLabelBase = false;
        byte labelType;
        int rangeSize;
        int labelBase;
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;
        private PcepObjectHeader labelRangeObjHeader;
        LinkedList<PcepValueType> llOptionalTlv = new LinkedList();

        @Override
        public PcepLabelRangeObject build() throws PcepParseException {
            PcepObjectHeader labelRangeObjHeader;
            PcepObjectHeader pcepObjectHeader = labelRangeObjHeader = this.bIsHeaderSet ? this.labelRangeObjHeader : DEFAULT_LABELRANGE_OBJECT_HEADER;
            if (!this.bIsLabelType) {
                throw new PcepParseException("LabelType NOT Set while building label range object.");
            }
            if (!this.bIsRangeSize) {
                throw new PcepParseException("RangeSize NOT Set while building label range object.");
            }
            if (!this.bIsLabelBase) {
                throw new PcepParseException("LabelBase NOT Set while building label range object.");
            }
            if (this.bIsPFlagSet) {
                labelRangeObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                labelRangeObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepLabelRangeObjectVer1(labelRangeObjHeader, this.labelType, this.rangeSize, this.labelBase, this.llOptionalTlv);
        }

        @Override
        public PcepObjectHeader getLabelRangeObjHeader() {
            return this.labelRangeObjHeader;
        }

        @Override
        public Builder setLabelRangeObjHeader(PcepObjectHeader obj) {
            this.labelRangeObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public byte getLabelType() {
            return this.labelType;
        }

        @Override
        public Builder setLabelType(byte labelType) {
            this.labelType = labelType;
            this.bIsLabelType = true;
            return this;
        }

        @Override
        public int getRangeSize() {
            return this.rangeSize;
        }

        @Override
        public Builder setRangeSize(int rangeSize) {
            this.rangeSize = rangeSize;
            this.bIsRangeSize = true;
            return this;
        }

        @Override
        public int getLabelBase() {
            return this.labelBase;
        }

        @Override
        public Builder setLabelBase(int labelBase) {
            this.labelBase = labelBase;
            this.bIsLabelBase = true;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

