/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLSObject;
import org.onosproject.pcepio.types.LinkAttributesTlv;
import org.onosproject.pcepio.types.LinkDescriptorsTlv;
import org.onosproject.pcepio.types.LocalNodeDescriptorsTlv;
import org.onosproject.pcepio.types.NodeAttributesTlv;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.RemoteNodeDescriptorsTlv;
import org.onosproject.pcepio.types.RoutingUniverseTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepLSObjectVer1
implements PcepLSObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepLSObjectVer1.class);
    public static final byte LS_OBJ_TYPE_NODE_VALUE = 1;
    public static final byte LS_OBJ_TYPE_LINK_VALUE = 2;
    public static final byte LS_OBJ_CLASS = -32;
    public static final byte LS_OBJECT_VERSION = 1;
    public static final short LS_OBJ_MINIMUM_LENGTH = 12;
    public static final byte DEFAULT_PROTOCOL_ID = 1;
    public static final boolean DEFAULT_R_FLAG = false;
    public static final boolean DEFAULT_S_FLAG = false;
    public static final int DEFAULT_LS_ID = 0;
    public static final int OBJECT_HEADER_LENGTH = 4;
    public static final int RIGHT_SHIFT_ONE = 1;
    public static final int RIGHT_FIRST_FLAG = 1;
    public static final int FLAG_SET_R_FLAG = 2;
    public static final int FLAG_SET_S_FLAG = 1;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    public static final int MINIMUM_TLV_HEADER_LENGTH = 4;
    public static final PcepObjectHeader DEFAULT_LS_OBJECT_HEADER = new PcepObjectHeader(-32, 1, false, false, 12);
    private PcepObjectHeader lsObjHeader;
    private byte protocolId;
    private boolean removeFlag;
    private boolean syncFlag;
    private long lsId;
    private List<PcepValueType> optionalTlvList;

    public PcepLSObjectVer1(PcepObjectHeader lsObjHeader, byte protocolId, boolean removeFlag, boolean syncFlag, long lsId, List<PcepValueType> optionalTlvList) {
        this.lsObjHeader = lsObjHeader;
        this.protocolId = protocolId;
        this.removeFlag = removeFlag;
        this.syncFlag = syncFlag;
        this.lsId = lsId;
        this.optionalTlvList = optionalTlvList;
    }

    @Override
    public PcepObjectHeader getLSObjHeader() {
        return this.lsObjHeader;
    }

    @Override
    public void setLSObjHeader(PcepObjectHeader obj) {
        this.lsObjHeader = obj;
    }

    @Override
    public byte getProtocolId() {
        return this.protocolId;
    }

    @Override
    public void setProtocolId(byte protId) {
        this.protocolId = protId;
    }

    @Override
    public boolean getRemoveFlag() {
        return this.removeFlag;
    }

    @Override
    public void setRemoveFlag(boolean removeFlag) {
        this.removeFlag = removeFlag;
    }

    @Override
    public boolean getSyncFlag() {
        return this.syncFlag;
    }

    @Override
    public void setSyncFlag(boolean syncFlag) {
        this.syncFlag = syncFlag;
    }

    @Override
    public long getLSId() {
        return this.lsId;
    }

    @Override
    public void setLSId(long lsId) {
        this.lsId = lsId;
    }

    @Override
    public List<PcepValueType> getOptionalTlv() {
        return this.optionalTlvList;
    }

    @Override
    public void setOptionalTlv(List<PcepValueType> optionalTlvList) {
        this.optionalTlvList = optionalTlvList;
    }

    public static PcepLSObject read(ChannelBuffer cb) throws PcepParseException {
        log.debug("read");
        PcepObjectHeader lsObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(lsObjHeader.getObjLen() - 4);
        byte protocolId = tempCb.readByte();
        tempCb.readShort();
        Integer iTemp = tempCb.readByte();
        boolean syncFlag = (iTemp & 1) == 1;
        boolean removeFlag = (iTemp & 2) == 2;
        long lsId = tempCb.readLong();
        List<PcepValueType> optionalTlvList = PcepLSObjectVer1.parseOptionalTlv(tempCb);
        return new PcepLSObjectVer1(lsObjHeader, protocolId, removeFlag, syncFlag, lsId, optionalTlvList);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.lsObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException("ObjectLength Index is " + objLenIndex);
        }
        cb.writeByte((int)this.protocolId);
        cb.writeShort(0);
        int bTemp = 0;
        if (this.syncFlag) {
            bTemp = 1;
        }
        if (this.removeFlag) {
            bTemp = (byte)(bTemp | 2);
        }
        cb.writeByte(bTemp);
        cb.writeLong(this.lsId);
        this.packOptionalTlv(cb);
        int length = cb.writerIndex() - objStartIndex;
        this.lsObjHeader.setObjLen((short)length);
        cb.setShort(objLenIndex, (int)((short)length));
        return cb.writerIndex();
    }

    protected static List<PcepValueType> parseOptionalTlv(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOutOptionalTlv = new LinkedList<PcepValueType>();
        while (4 <= cb.readableBytes()) {
            PcepValueType tlv;
            short hType = cb.readShort();
            short hLength = cb.readShort();
            long lValue = 0L;
            switch (hType) {
                case -255: {
                    lValue = cb.readLong();
                    tlv = new RoutingUniverseTlv(lValue);
                    break;
                }
                case -254: {
                    tlv = LocalNodeDescriptorsTlv.read(cb, hLength);
                    break;
                }
                case -253: {
                    tlv = RemoteNodeDescriptorsTlv.read(cb, hLength);
                    break;
                }
                case -252: {
                    tlv = LinkDescriptorsTlv.read(cb, hLength);
                    break;
                }
                case -251: {
                    tlv = NodeAttributesTlv.read(cb, hLength);
                    break;
                }
                case -250: {
                    tlv = LinkAttributesTlv.read(cb, hLength);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported TLV type :" + hType);
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= cb.readableBytes()) {
                cb.skipBytes(pad);
            }
            llOutOptionalTlv.add(tlv);
        }
        if (0 < cb.readableBytes()) {
            throw new PcepParseException("Optional Tlv parsing error. Extra bytes received.");
        }
        return llOutOptionalTlv;
    }

    protected int packOptionalTlv(ChannelBuffer cb) {
        ListIterator<PcepValueType> listIterator = this.optionalTlvList.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = listIterator.next();
            if (tlv == null) {
                log.debug("TLV is null from OptionalTlv list");
                continue;
            }
            tlv.write(cb);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
        }
        return cb.writerIndex();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("ObjectHeader", (Object)this.lsObjHeader).add("ProtocolId", (int)this.protocolId).add("RFlag", this.removeFlag ? 1 : 0).add("SFlag", this.syncFlag ? 1 : 0).add("LsId", this.lsId).add("OptionalTlv", this.optionalTlvList).toString();
    }

    public static class Builder
    implements PcepLSObject.Builder {
        private boolean isHeaderSet = false;
        private boolean isProtocolIdSet = false;
        private boolean isRemoveFlagSet = false;
        private boolean isSyncFlagSet = false;
        private boolean isLSIdSet = false;
        private PcepObjectHeader lsObjHeader;
        private byte protocolId;
        private boolean removeFlag;
        private boolean syncFlag;
        private long lsId;
        private List<PcepValueType> optionalTlvList = new LinkedList<PcepValueType>();
        private boolean isProcRuleFlagSet = false;
        private boolean procRuleFlag;
        private boolean isIgnoreFlagSet = false;
        private boolean ignoreFlag;

        @Override
        public PcepLSObject build() {
            long lsId;
            PcepObjectHeader lsObjHeader = this.isHeaderSet ? this.lsObjHeader : DEFAULT_LS_OBJECT_HEADER;
            byte protocolId = this.isProtocolIdSet ? this.protocolId : (byte)1;
            boolean removeFlag = this.isRemoveFlagSet ? this.removeFlag : false;
            boolean syncFlag = this.isSyncFlagSet ? this.syncFlag : false;
            long l = lsId = this.isLSIdSet ? this.lsId : 0L;
            if (this.isProcRuleFlagSet) {
                lsObjHeader.setPFlag(this.procRuleFlag);
            }
            if (this.isIgnoreFlagSet) {
                lsObjHeader.setIFlag(this.ignoreFlag);
            }
            return new PcepLSObjectVer1(lsObjHeader, protocolId, removeFlag, syncFlag, lsId, this.optionalTlvList);
        }

        @Override
        public PcepObjectHeader getLSObjHeader() {
            return this.lsObjHeader;
        }

        @Override
        public Builder setLSObjHeader(PcepObjectHeader obj) {
            this.lsObjHeader = obj;
            this.isHeaderSet = true;
            return this;
        }

        @Override
        public byte getProtocolId() {
            return this.protocolId;
        }

        @Override
        public Builder setProtocolId(byte protId) {
            this.protocolId = protId;
            this.isProtocolIdSet = true;
            return this;
        }

        @Override
        public boolean getRemoveFlag() {
            return this.removeFlag;
        }

        @Override
        public Builder setRemoveFlag(boolean removeFlag) {
            this.removeFlag = removeFlag;
            this.isRemoveFlagSet = true;
            return this;
        }

        @Override
        public boolean getSyncFlag() {
            return this.syncFlag;
        }

        @Override
        public Builder setSyncFlag(boolean syncFlag) {
            this.syncFlag = syncFlag;
            this.isSyncFlagSet = true;
            return this;
        }

        @Override
        public long getLSId() {
            return this.lsId;
        }

        @Override
        public Builder setLSId(long lsId) {
            this.lsId = lsId;
            this.isLSIdSet = true;
            return this;
        }

        @Override
        public List<PcepValueType> getOptionalTlv() {
            return this.optionalTlvList;
        }

        @Override
        public Builder setOptionalTlv(List<PcepValueType> optionalTlvList) {
            this.optionalTlvList = optionalTlvList;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.procRuleFlag = value;
            this.isProcRuleFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.ignoreFlag = value;
            this.isIgnoreFlagSet = true;
            return this;
        }
    }
}

