/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepIroObject;
import org.onosproject.pcepio.types.IPv4SubObject;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepIroObjectVer1
implements PcepIroObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepIroObjectVer1.class);
    public static final byte IRO_OBJ_TYPE = 1;
    public static final byte IRO_OBJ_CLASS = 10;
    public static final byte IRO_OBJECT_VERSION = 1;
    public static final short IRO_OBJ_MINIMUM_LENGTH = 12;
    public static final int OBJECT_HEADER_LENGTH = 4;
    public static final int YTYPE_SHIFT_VALUE = 127;
    public static final PcepObjectHeader DEFAULT_IRO_OBJECT_HEADER = new PcepObjectHeader(10, 1, false, false, 12);
    private short iroObjType = 0;
    private byte yLength;
    private byte yPrefixLength;
    private byte yResvd;
    private PcepObjectHeader iroObjHeader;
    private LinkedList<PcepValueType> llSubObjects = new LinkedList();

    public PcepIroObjectVer1() {
        this.iroObjHeader = null;
        this.iroObjType = 0;
        this.yLength = 0;
    }

    public PcepIroObjectVer1(PcepObjectHeader iroObjHeader, LinkedList<PcepValueType> llSubObjects) {
        this.iroObjHeader = iroObjHeader;
        this.llSubObjects = llSubObjects;
    }

    public PcepObjectHeader getIroObjHeader() {
        return this.iroObjHeader;
    }

    public void setIroObjHeader(PcepObjectHeader obj) {
        this.iroObjHeader = obj;
    }

    @Override
    public LinkedList<PcepValueType> getSubObjects() {
        return this.llSubObjects;
    }

    @Override
    public void setSubObjects(LinkedList<PcepValueType> llSubObjects) {
        this.llSubObjects = llSubObjects;
    }

    public static PcepIroObject read(ChannelBuffer cb) throws PcepParseException {
        PcepObjectHeader iroObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(iroObjHeader.getObjLen() - 4);
        LinkedList<PcepValueType> llSubObjects = PcepIroObjectVer1.parseSubObjects(tempCb);
        return new PcepIroObjectVer1(iroObjHeader, llSubObjects);
    }

    protected static LinkedList<PcepValueType> parseSubObjects(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llSubObjects = new LinkedList<PcepValueType>();
        while (0 < cb.readableBytes()) {
            PcepValueType subObj;
            byte yType = cb.readByte();
            yType = (byte)(yType & 0x7F);
            byte hLength = cb.readByte();
            switch (yType) {
                case 1: {
                    subObj = IPv4SubObject.read(cb);
                    break;
                }
                default: {
                    throw new PcepParseException("Invalid sub object. Type: " + yType);
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= cb.readableBytes()) {
                cb.skipBytes(pad);
            }
            llSubObjects.add(subObj);
        }
        return llSubObjects;
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.iroObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException(" ObjectLength is " + objLenIndex);
        }
        ListIterator listIterator = this.llSubObjects.listIterator();
        while (listIterator.hasNext()) {
            ((PcepValueType)listIterator.next()).write(cb);
        }
        int length = cb.writerIndex() - objStartIndex;
        this.iroObjHeader.setObjLen((short)length);
        int pad = length % 4;
        if (pad != 0) {
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
            length += pad;
        }
        cb.setShort(objLenIndex, (int)((short)length));
        objLenIndex = cb.writerIndex();
        return objLenIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("IroObjectHeader", (Object)this.iroObjHeader).add("SubObjects", this.llSubObjects).toString();
    }

    public static class Builder
    implements PcepIroObject.Builder {
        private boolean bIsHeaderSet = false;
        private PcepObjectHeader iroObjHeader;
        LinkedList<PcepValueType> llSubObjects = new LinkedList();
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepIroObject build() {
            PcepObjectHeader iroObjHeader;
            PcepObjectHeader pcepObjectHeader = iroObjHeader = this.bIsHeaderSet ? this.iroObjHeader : DEFAULT_IRO_OBJECT_HEADER;
            if (this.bIsPFlagSet) {
                iroObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                iroObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepIroObjectVer1(iroObjHeader, this.llSubObjects);
        }

        @Override
        public PcepObjectHeader getIroObjHeader() {
            return this.iroObjHeader;
        }

        @Override
        public Builder setIroObjHeader(PcepObjectHeader obj) {
            this.iroObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getSubObjects() {
            return this.llSubObjects;
        }

        @Override
        public Builder setSubObjects(LinkedList<PcepValueType> llSubObjects) {
            this.llSubObjects = llSubObjects;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

