/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcInitiatedLspRequest;
import org.onosproject.pcepio.protocol.PcepAttribute;
import org.onosproject.pcepio.protocol.PcepEndPointsObject;
import org.onosproject.pcepio.protocol.PcepEroObject;
import org.onosproject.pcepio.protocol.PcepInitiateMsg;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepMessageWriter;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.protocol.ver1.PcInitiatedLspRequestVer1;
import org.onosproject.pcepio.protocol.ver1.PcepAttributeVer1;
import org.onosproject.pcepio.protocol.ver1.PcepEndPointsObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepEroObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepLspObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepSrpObjectVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PcepInitiateMsgVer1
implements PcepInitiateMsg {
    protected static final Logger log = LoggerFactory.getLogger(PcepInitiateMsgVer1.class);
    static final byte PACKET_VERSION = 1;
    public static final short PACKET_MINIMUM_LENGTH = 24;
    public static final short MINIMUM_COMMON_HEADER_LENGTH = 4;
    public static final PcepType MSG_TYPE = PcepType.INITIATE;
    private LinkedList<PcInitiatedLspRequest> llPcInitiatedLspRequestList;
    public static final Reader READER = new Reader();
    static final Writer WRITER = new Writer();

    PcepInitiateMsgVer1(LinkedList<PcInitiatedLspRequest> llPcInitiatedLspRequestList) {
        if (llPcInitiatedLspRequestList == null) {
            throw new NullPointerException("PcInitiatedLspRequestList cannot be null.");
        }
        this.llPcInitiatedLspRequestList = llPcInitiatedLspRequestList;
    }

    @Override
    public void writeTo(ChannelBuffer cb) throws PcepParseException {
        WRITER.write(cb, this);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public PcepType getType() {
        return MSG_TYPE;
    }

    @Override
    public LinkedList<PcInitiatedLspRequest> getPcInitiatedLspRequestList() {
        return this.llPcInitiatedLspRequestList;
    }

    @Override
    public void setPcInitiatedLspRequestList(LinkedList<PcInitiatedLspRequest> ll) {
        this.llPcInitiatedLspRequestList = ll;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("PcInitiaitedLspRequestList", this.llPcInitiatedLspRequestList).toString();
    }

    static class Writer
    implements PcepMessageWriter<PcepInitiateMsgVer1> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer cb, PcepInitiateMsgVer1 message) throws PcepParseException {
            boolean isDelLspRequest = false;
            int startIndex = cb.writerIndex();
            cb.writeByte(32);
            cb.writeByte((int)MSG_TYPE.getType());
            int msgLenIndex = cb.writerIndex();
            cb.writeShort(0);
            ListIterator listIterator = message.llPcInitiatedLspRequestList.listIterator();
            while (listIterator.hasNext()) {
                PcInitiatedLspRequest listReq = (PcInitiatedLspRequest)listIterator.next();
                PcepSrpObject srpObj = listReq.getSrpObject();
                if (srpObj == null) {
                    throw new PcepParseException("SRP Object is mandatory for PcInitiate message.");
                }
                isDelLspRequest = srpObj.getRFlag();
                srpObj.write(cb);
                PcepLspObject lspObj = listReq.getLspObject();
                if (lspObj == null) {
                    throw new PcepParseException("LSP Object is mandatory for PcInitiate message.");
                }
                lspObj.write(cb);
                if (isDelLspRequest) continue;
                PcepEndPointsObject endPointObj = listReq.getEndPointsObject();
                if (endPointObj == null) {
                    throw new PcepParseException("End points Object is mandatory for PcInitiate message.");
                }
                endPointObj.write(cb);
                PcepEroObject eroObj = listReq.getEroObject();
                if (eroObj == null) {
                    throw new PcepParseException("ERO Object is mandatory for PcInitiate message.");
                }
                eroObj.write(cb);
                PcepAttribute pcepAttribute = listReq.getPcepAttribute();
                if (pcepAttribute == null) continue;
                pcepAttribute.write(cb);
            }
            int length = cb.writerIndex() - startIndex;
            cb.setShort(msgLenIndex, (int)((short)length));
        }
    }

    static class Builder
    implements PcepInitiateMsg.Builder {
        LinkedList<PcInitiatedLspRequest> llPcInitiatedLspRequestList;

        Builder() {
        }

        @Override
        public PcepVersion getVersion() {
            return PcepVersion.PCEP_1;
        }

        @Override
        public PcepType getType() {
            return PcepType.INITIATE;
        }

        @Override
        public PcepInitiateMsg build() {
            return new PcepInitiateMsgVer1(this.llPcInitiatedLspRequestList);
        }

        @Override
        public LinkedList<PcInitiatedLspRequest> getPcInitiatedLspRequestList() {
            return this.llPcInitiatedLspRequestList;
        }

        @Override
        public Builder setPcInitiatedLspRequestList(LinkedList<PcInitiatedLspRequest> ll) {
            this.llPcInitiatedLspRequestList = ll;
            return this;
        }
    }

    static class Reader
    implements PcepMessageReader<PcepInitiateMsg> {
        LinkedList<PcInitiatedLspRequest> llPcInitiatedLspRequestList;

        Reader() {
        }

        @Override
        public PcepInitiateMsg readFrom(ChannelBuffer cb) throws PcepParseException {
            if (cb.readableBytes() < 24) {
                return null;
            }
            this.llPcInitiatedLspRequestList = new LinkedList();
            byte version = cb.readByte();
            if ((version = (byte)(version >> 5)) != 1) {
                throw new PcepParseException("Wrong version. Expected=PcepVersion.PCEP_1(1), received=" + version);
            }
            byte type = cb.readByte();
            if (type != MSG_TYPE.getType()) {
                throw new PcepParseException("Wrong type. Expected=PcepType.INITIATE(12), recived=" + type);
            }
            short length = cb.readShort();
            if (length < 24) {
                throw new PcepParseException("Wrong length. Initiate message length expected to be >= 24, but received=" + length);
            }
            log.debug("reading PcInitiate message of length " + length);
            if (!this.parsePcInitiatedLspRequestList(cb)) {
                throw new PcepParseException("Parsing PCE-initiated-lsp-Request-list failed");
            }
            return new PcepInitiateMsgVer1(this.llPcInitiatedLspRequestList);
        }

        public boolean parsePcInitiatedLspRequestList(ChannelBuffer cb) throws PcepParseException {
            boolean isDelLspRequest = false;
            if (cb == null) {
                throw new PcepParseException("Channel buffer is empty");
            }
            while (0 < cb.readableBytes()) {
                PcInitiatedLspRequestVer1 pceInitLspReq = new PcInitiatedLspRequestVer1();
                PcepSrpObject srpObj = PcepSrpObjectVer1.read(cb);
                pceInitLspReq.setSrpObject(srpObj);
                isDelLspRequest = srpObj.getRFlag();
                PcepLspObject lspObj = PcepLspObjectVer1.read(cb);
                pceInitLspReq.setLspObject(lspObj);
                if (!isDelLspRequest) {
                    PcepEndPointsObject endPointObj = PcepEndPointsObjectVer1.read(cb);
                    pceInitLspReq.setEndPointsObject(endPointObj);
                    PcepEroObject eroObj = PcepEroObjectVer1.read(cb);
                    pceInitLspReq.setEroObject(eroObj);
                    if (cb.readableBytes() > 4) {
                        pceInitLspReq.setPcepAttribute(PcepAttributeVer1.read(cb));
                    }
                }
                this.llPcInitiatedLspRequestList.add(pceInitLspReq);
            }
            return true;
        }
    }
}

