/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepError;
import org.onosproject.pcepio.protocol.PcepErrorObject;
import org.onosproject.pcepio.protocol.PcepLSObject;
import org.onosproject.pcepio.protocol.PcepRPObject;
import org.onosproject.pcepio.protocol.ver1.PcepErrorObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepLSObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepRPObjectVer1;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepErrorVer1
implements PcepError {
    protected static final Logger log = LoggerFactory.getLogger(PcepErrorVer1.class);
    private boolean isErroInfoSet;
    private List<PcepErrorObject> errObjList;
    private List<PcepRPObject> rpObjList;
    private List<PcepLSObject> lsObjList;
    private boolean isLSObjListSet;
    public static final int OBJECT_HEADER_LENGTH = 4;

    public PcepErrorVer1() {
        this.rpObjList = null;
        this.lsObjList = null;
        this.errObjList = null;
    }

    public PcepErrorVer1(List<PcepRPObject> rpObjList, List<PcepLSObject> lsObjList, List<PcepErrorObject> errObjListObjList) {
        this.rpObjList = rpObjList;
        this.lsObjList = lsObjList;
        this.errObjList = errObjListObjList;
    }

    public PcepErrorVer1(List<PcepErrorObject> errObjList) {
        this.rpObjList = null;
        this.lsObjList = null;
        this.errObjList = errObjList;
    }

    @Override
    public List<PcepRPObject> getRPObjList() {
        return this.rpObjList;
    }

    @Override
    public List<PcepLSObject> getLSObjList() {
        return this.lsObjList;
    }

    @Override
    public List<PcepErrorObject> getErrorObjList() {
        return this.errObjList;
    }

    public void parseRPList(ChannelBuffer cb) throws PcepParseException {
        this.rpObjList = new LinkedList<PcepRPObject>();
        if (cb.readableBytes() < 4) {
            log.debug("Unable to find RP Object");
            return;
        }
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        byte yObjClass = tempObjHeader.getObjClass();
        byte yObjType = tempObjHeader.getObjType();
        while (yObjClass == 2 && yObjType == 1) {
            PcepRPObject rpObj = PcepRPObjectVer1.read(cb);
            this.rpObjList.add(rpObj);
            if (cb.readableBytes() <= 4) break;
            cb.markReaderIndex();
            tempObjHeader = PcepObjectHeader.read(cb);
            cb.resetReaderIndex();
            yObjClass = tempObjHeader.getObjClass();
            yObjType = tempObjHeader.getObjType();
        }
    }

    public void parseLSList(ChannelBuffer cb) throws PcepParseException {
        this.lsObjList = new LinkedList<PcepLSObject>();
        if (cb.readableBytes() < 4) {
            log.debug("Unable to find LS Object");
            return;
        }
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        byte yObjClass = tempObjHeader.getObjClass();
        byte yObjType = tempObjHeader.getObjType();
        while (yObjClass == -32 && (yObjType == 1 || yObjType == 2)) {
            PcepLSObject lsObj = PcepLSObjectVer1.read(cb);
            this.lsObjList.add(lsObj);
            if (cb.readableBytes() <= 4) break;
            cb.markReaderIndex();
            tempObjHeader = PcepObjectHeader.read(cb);
            cb.resetReaderIndex();
            yObjClass = tempObjHeader.getObjClass();
            yObjType = tempObjHeader.getObjType();
        }
    }

    public void parseErrObjList(ChannelBuffer cb) throws PcepParseException {
        boolean bIsErrorObjFound = false;
        this.errObjList = new LinkedList<PcepErrorObject>();
        if (cb.readableBytes() < 4) {
            throw new PcepParseException("Unable to find PCEP-ERROR Object");
        }
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        byte yObjClass = tempObjHeader.getObjClass();
        byte yObjType = tempObjHeader.getObjType();
        while (yObjClass == 13 && yObjType == 1) {
            PcepErrorObject errorObject = PcepErrorObjectVer1.read(cb);
            this.errObjList.add(errorObject);
            bIsErrorObjFound = true;
            if (cb.readableBytes() <= 4) break;
            cb.markReaderIndex();
            tempObjHeader = PcepObjectHeader.read(cb);
            cb.resetReaderIndex();
            yObjClass = tempObjHeader.getObjClass();
            yObjType = tempObjHeader.getObjType();
        }
        if (!bIsErrorObjFound) {
            throw new PcepParseException("At least one PCEP-ERROR Object should be present.");
        }
    }

    public static PcepErrorVer1 read(ChannelBuffer cb) throws PcepParseException {
        if (cb.readableBytes() < 4) {
            throw new PcepParseException("Unknown Object");
        }
        PcepErrorVer1 pcepError = new PcepErrorVer1();
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        byte yObjClass = tempObjHeader.getObjClass();
        if (yObjClass == 2) {
            log.debug("RP_LIST");
            pcepError.parseRPList(cb);
            yObjClass = PcepErrorVer1.checkNextObject(cb);
        } else if (yObjClass == -32) {
            log.debug("LS_LIST");
            pcepError.parseLSList(cb);
            yObjClass = PcepErrorVer1.checkNextObject(cb);
        }
        if (yObjClass == 13) {
            log.debug("PCEP-ERROR obj list");
            pcepError.parseErrObjList(cb);
            yObjClass = PcepErrorVer1.checkNextObject(cb);
        }
        return pcepError;
    }

    private static byte checkNextObject(ChannelBuffer cb) {
        if (cb.readableBytes() < 4) {
            return 0;
        }
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        return tempObjHeader.getObjClass();
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int iLenStartIndex = cb.writerIndex();
        if (this.isErroInfoSet) {
            ListIterator<PcepRPObject> rpObjlistIterator = this.rpObjList.listIterator();
            while (rpObjlistIterator.hasNext()) {
                rpObjlistIterator.next().write(cb);
            }
        }
        if (this.isLSObjListSet) {
            ListIterator<PcepLSObject> teObjlistIterator = this.lsObjList.listIterator();
            while (teObjlistIterator.hasNext()) {
                teObjlistIterator.next().write(cb);
            }
        }
        ListIterator<PcepErrorObject> errlistIterator = this.errObjList.listIterator();
        while (errlistIterator.hasNext()) {
            errlistIterator.next().write(cb);
        }
        return cb.writerIndex() - iLenStartIndex;
    }

    @Override
    public void setRPObjList(List<PcepRPObject> rpObjList) {
        this.rpObjList = rpObjList;
    }

    @Override
    public void setLSObjList(List<PcepLSObject> lsObjList) {
        this.lsObjList = lsObjList;
    }

    @Override
    public void setErrorObjList(List<PcepErrorObject> errObjList) {
        this.errObjList = errObjList;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("RpObjectList", this.rpObjList).add("LsObjectList", this.lsObjList).add("ErrorObjectList", this.errObjList).toString();
    }

    public static class Builder
    implements PcepError.Builder {
        private List<PcepRPObject> rpObjList;
        private List<PcepLSObject> lsObjList;
        private List<PcepErrorObject> errObjList;

        @Override
        public PcepError build() {
            return new PcepErrorVer1(this.rpObjList, this.lsObjList, this.errObjList);
        }

        @Override
        public List<PcepRPObject> getRPObjList() {
            return this.rpObjList;
        }

        @Override
        public Builder setRPObjList(List<PcepRPObject> rpObjList) {
            this.rpObjList = rpObjList;
            return this;
        }

        @Override
        public List<PcepLSObject> getLSObjList() {
            return this.lsObjList;
        }

        @Override
        public Builder setLSObjList(List<PcepLSObject> lsObjList) {
            this.lsObjList = lsObjList;
            return this;
        }

        @Override
        public List<PcepErrorObject> getErrorObjList() {
            return this.errObjList;
        }

        @Override
        public Builder setErrorObjList(List<PcepErrorObject> errObjList) {
            this.errObjList = errObjList;
            return this;
        }
    }
}

