/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepErrorInfo;
import org.onosproject.pcepio.protocol.PcepErrorMsg;
import org.onosproject.pcepio.protocol.PcepErrorObject;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepMessageWriter;
import org.onosproject.pcepio.protocol.PcepOpenObject;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.protocol.ver1.PcepErrorInfoVer1;
import org.onosproject.pcepio.protocol.ver1.PcepErrorObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepOpenMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepOpenObjectVer1;
import org.onosproject.pcepio.types.ErrorObjListWithOpen;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepErrorMsgVer1
implements PcepErrorMsg {
    protected static final Logger log = LoggerFactory.getLogger(PcepOpenMsgVer1.class);
    public static final byte PACKET_VERSION = 1;
    public static final int PACKET_MINIMUM_LENGTH = 12;
    public static final PcepType MSG_TYPE = PcepType.ERROR;
    private ErrorObjListWithOpen errObjListWithOpen;
    private PcepErrorInfo errInfo;
    public static final Reader READER = new Reader();
    public static final Writer WRITER = new Writer();

    public PcepErrorMsgVer1() {
        this.errObjListWithOpen = null;
        this.errInfo = null;
    }

    public PcepErrorMsgVer1(ErrorObjListWithOpen errObjListWithOpen, PcepErrorInfo errInfo) {
        this.errObjListWithOpen = errObjListWithOpen;
        this.errInfo = errInfo;
    }

    @Override
    public void writeTo(ChannelBuffer cb) throws PcepParseException {
        WRITER.write(cb, this);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public PcepType getType() {
        return MSG_TYPE;
    }

    @Override
    public ErrorObjListWithOpen getErrorObjListWithOpen() {
        return this.errObjListWithOpen;
    }

    @Override
    public void setErrorObjListWithOpen(ErrorObjListWithOpen errObjListWithOpen) {
        this.errObjListWithOpen = errObjListWithOpen;
    }

    @Override
    public PcepErrorInfo getPcepErrorInfo() {
        return this.errInfo;
    }

    @Override
    public void setPcepErrorInfo(PcepErrorInfo errInfo) {
        this.errInfo = errInfo;
    }

    public List<Integer> getErrorType() {
        List<Integer> llErrorType = new LinkedList<Integer>();
        if (this.errObjListWithOpen != null && this.errObjListWithOpen.isErrorObjListWithOpenPresent()) {
            llErrorType = this.errObjListWithOpen.getErrorType();
        } else if (this.errInfo != null && this.errInfo.isErrorInfoPresent()) {
            llErrorType = this.errInfo.getErrorType();
        }
        return llErrorType;
    }

    public List<Integer> getErrorValue() {
        List<Integer> llErrorValue = new LinkedList<Integer>();
        if (this.errObjListWithOpen != null && this.errObjListWithOpen.isErrorObjListWithOpenPresent()) {
            llErrorValue = this.errObjListWithOpen.getErrorValue();
        } else if (this.errInfo != null && this.errInfo.isErrorInfoPresent()) {
            llErrorValue = this.errInfo.getErrorValue();
        }
        return llErrorValue;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper(this.getClass()).omitNullValues();
        if (this.errObjListWithOpen != null && this.errObjListWithOpen.isErrorObjListWithOpenPresent()) {
            toStrHelper.add("ErrorObjectListWithOpen", (Object)this.errObjListWithOpen);
        }
        if (this.errInfo != null && this.errInfo.isErrorInfoPresent()) {
            toStrHelper.add("ErrorInfo", (Object)this.errInfo);
        }
        return toStrHelper.toString();
    }

    static class Writer
    implements PcepMessageWriter<PcepErrorMsgVer1> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer cb, PcepErrorMsgVer1 message) throws PcepParseException {
            int startIndex = cb.writerIndex();
            cb.writeByte(32);
            cb.writeByte((int)MSG_TYPE.getType());
            int msgLenIndex = cb.writerIndex();
            cb.writeShort(0);
            ErrorObjListWithOpen errObjListWithOpen = message.getErrorObjListWithOpen();
            PcepErrorInfo errInfo = message.getPcepErrorInfo();
            if (errObjListWithOpen != null && errObjListWithOpen.isErrorObjListWithOpenPresent()) {
                errObjListWithOpen.write(cb);
            } else if (errInfo != null && errInfo.isErrorInfoPresent()) {
                errInfo.write(cb);
            } else {
                throw new PcepParseException("Empty PCEP-ERROR message.");
            }
            int length = cb.writerIndex() - startIndex;
            cb.setShort(msgLenIndex, (int)((short)length));
        }
    }

    public static class Builder
    implements PcepErrorMsg.Builder {
        private ErrorObjListWithOpen errObjListWithOpen = null;
        private PcepErrorInfo errInfo = null;

        @Override
        public PcepVersion getVersion() {
            return PcepVersion.PCEP_1;
        }

        @Override
        public PcepType getType() {
            return PcepType.ERROR;
        }

        @Override
        public PcepErrorMsg build() {
            return new PcepErrorMsgVer1(this.errObjListWithOpen, this.errInfo);
        }

        @Override
        public ErrorObjListWithOpen getErrorObjListWithOpen() {
            return this.errObjListWithOpen;
        }

        @Override
        public Builder setErrorObjListWithOpen(ErrorObjListWithOpen errObjListWithOpen) {
            this.errObjListWithOpen = errObjListWithOpen;
            return this;
        }

        @Override
        public PcepErrorInfo getPcepErrorInfo() {
            return this.errInfo;
        }

        @Override
        public Builder setPcepErrorInfo(PcepErrorInfo errInfo) {
            this.errInfo = errInfo;
            return this;
        }
    }

    public static class Reader
    implements PcepMessageReader<PcepErrorMsg> {
        ErrorObjListWithOpen errObjListWithOpen;
        PcepErrorInfo errInfo;
        PcepObjectHeader tempObjHeader;

        @Override
        public PcepErrorMsg readFrom(ChannelBuffer cb) throws PcepParseException {
            this.errObjListWithOpen = null;
            this.errInfo = null;
            this.tempObjHeader = null;
            if (cb.readableBytes() < 12) {
                throw new PcepParseException("Packet size is less than the minimum length.");
            }
            byte version = cb.readByte();
            if ((version = (byte)(version >> 5)) != 1) {
                throw new PcepParseException("Wrong version: Expected=PcepVersion.PCEP_1(1), got=" + version);
            }
            byte type = cb.readByte();
            if (type != MSG_TYPE.getType()) {
                throw new PcepParseException("Wrong type: Expected=PcepType.ERROR(6), got=" + type);
            }
            short length = cb.readShort();
            if (length < 12) {
                throw new PcepParseException("Wrong length: Expected to be >= 12, was: " + length);
            }
            this.parsePCErrMsg(cb);
            if (0 < cb.readableBytes()) {
                PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
                throw new PcepParseException("Unexpected Object found. Object Class : " + tempObjHeader.getObjClass());
            }
            return new PcepErrorMsgVer1(this.errObjListWithOpen, this.errInfo);
        }

        public void parsePCErrMsg(ChannelBuffer cb) throws PcepParseException {
            if (0 >= cb.readableBytes()) {
                throw new PcepParseException("PCEP-ERROR message came with empty objects.");
            }
            LinkedList<PcepErrorObject> llErrObjList = new LinkedList<PcepErrorObject>();
            PcepObjectHeader tempObjHeader = this.parseErrorObjectList(llErrObjList, cb);
            if (tempObjHeader != null && tempObjHeader.getObjClass() == 1) {
                if (llErrObjList.isEmpty()) {
                    throw new PcepParseException("<error-obj-list> should be present if OPEN-OBJECT exists");
                }
                PcepOpenObject pcepOpenObj = PcepOpenObjectVer1.read(cb);
                this.errObjListWithOpen = new ErrorObjListWithOpen(llErrObjList, pcepOpenObj);
            } else if (tempObjHeader != null && (tempObjHeader.getObjClass() == 2 || tempObjHeader.getObjClass() == -32)) {
                this.errInfo = new PcepErrorInfoVer1(null, null, llErrObjList);
                this.errInfo.read(cb);
            } else if (!llErrObjList.isEmpty()) {
                this.errObjListWithOpen = new ErrorObjListWithOpen(llErrObjList);
            } else {
                throw new PcepParseException("Empty PCEP-ERROR message.");
            }
        }

        public PcepObjectHeader parseErrorObjectList(List<PcepErrorObject> llErrObjList, ChannelBuffer cb) throws PcepParseException {
            PcepObjectHeader tempObjHeader = null;
            while (0 < cb.readableBytes()) {
                cb.markReaderIndex();
                tempObjHeader = PcepObjectHeader.read(cb);
                cb.resetReaderIndex();
                if (tempObjHeader.getObjClass() != 13) break;
                llErrObjList.add(PcepErrorObjectVer1.read(cb));
            }
            return tempObjHeader;
        }
    }
}

