/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepError;
import org.onosproject.pcepio.protocol.PcepErrorInfo;
import org.onosproject.pcepio.protocol.PcepErrorObject;
import org.onosproject.pcepio.protocol.PcepLSObject;
import org.onosproject.pcepio.protocol.PcepRPObject;
import org.onosproject.pcepio.protocol.ver1.PcepErrorVer1;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepErrorInfoVer1
implements PcepErrorInfo {
    protected static final Logger log = LoggerFactory.getLogger(PcepErrorInfoVer1.class);
    private List<PcepError> errList;

    public PcepErrorInfoVer1(List<PcepRPObject> llRPObjList, List<PcepLSObject> llLSObjList, List<PcepErrorObject> llErrObjList) {
        this.errList = new LinkedList<PcepError>();
        if (llErrObjList != null && !llErrObjList.isEmpty()) {
            this.errList.add(new PcepErrorVer1(llRPObjList, llLSObjList, llErrObjList));
        }
    }

    public PcepErrorInfoVer1(List<PcepError> errll) {
        this.errList = errll;
    }

    @Override
    public boolean isErrorInfoPresent() {
        return !this.errList.isEmpty();
    }

    @Override
    public void read(ChannelBuffer cb) throws PcepParseException {
        while (0 < cb.readableBytes()) {
            cb.markReaderIndex();
            PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
            cb.resetReaderIndex();
            byte yObjClass = tempObjHeader.getObjClass();
            if (yObjClass != 2 && yObjClass != -32 && yObjClass != 13) {
                throw new PcepParseException("Unknown Object is present in PCEP-ERROR. Object Class: " + yObjClass);
            }
            this.errList.add(PcepErrorVer1.read(cb));
        }
    }

    @Override
    public void write(ChannelBuffer cb) throws PcepParseException {
        ListIterator<PcepError> listIterator = this.errList.listIterator();
        while (listIterator.hasNext()) {
            List<PcepLSObject> llLSObjList;
            PcepError pcepError = listIterator.next();
            List<PcepRPObject> llRPObjList = pcepError.getRPObjList();
            if (llRPObjList != null) {
                ListIterator<PcepRPObject> rpListIterator = llRPObjList.listIterator();
                while (rpListIterator.hasNext()) {
                    rpListIterator.next().write(cb);
                }
            }
            if ((llLSObjList = pcepError.getLSObjList()) != null) {
                ListIterator<PcepLSObject> teListIterator = llLSObjList.listIterator();
                while (teListIterator.hasNext()) {
                    teListIterator.next().write(cb);
                }
            }
            boolean bIsErrorObjListFound = false;
            List<PcepErrorObject> llErrObjList = pcepError.getErrorObjList();
            if (llErrObjList != null) {
                ListIterator<PcepErrorObject> errObjListIterator = llErrObjList.listIterator();
                while (errObjListIterator.hasNext()) {
                    errObjListIterator.next().write(cb);
                    bIsErrorObjListFound = true;
                }
            }
            if (bIsErrorObjListFound) continue;
            throw new PcepParseException("<error-obj-list> is mandatory.");
        }
    }

    @Override
    public List<Integer> getErrorType() {
        LinkedList<Integer> errorType = new LinkedList<Integer>();
        ListIterator<PcepError> listIterator = this.errList.listIterator();
        while (listIterator.hasNext()) {
            PcepError pcepError = listIterator.next();
            List<PcepErrorObject> llErrObjList = pcepError.getErrorObjList();
            if (llErrObjList == null) continue;
            ListIterator<PcepErrorObject> errObjListIterator = llErrObjList.listIterator();
            while (errObjListIterator.hasNext()) {
                PcepErrorObject errObj = errObjListIterator.next();
                int error = errObj.getErrorType();
                errorType.add(error);
            }
        }
        return errorType;
    }

    @Override
    public List<Integer> getErrorValue() {
        LinkedList<Integer> errorValue = new LinkedList<Integer>();
        ListIterator<PcepError> listIterator = this.errList.listIterator();
        while (listIterator.hasNext()) {
            PcepError pcepError = listIterator.next();
            List<PcepErrorObject> llErrObjList = pcepError.getErrorObjList();
            if (llErrObjList == null) continue;
            ListIterator<PcepErrorObject> errObjListIterator = llErrObjList.listIterator();
            while (errObjListIterator.hasNext()) {
                PcepErrorObject errObj = errObjListIterator.next();
                byte error = errObj.getErrorValue();
                errorValue.add(Integer.valueOf(error));
            }
        }
        return errorValue;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ErrorList", this.errList).toString();
    }

    public static class Builder
    implements PcepErrorInfo.Builder {
        private List<PcepError> errll;

        @Override
        public PcepErrorInfo build() {
            return new PcepErrorInfoVer1(this.errll);
        }

        @Override
        public List<PcepError> getPcepErrorList() {
            return this.errll;
        }

        @Override
        public Builder setPcepErrorList(List<PcepError> errll) {
            this.errll = errll;
            return this;
        }
    }
}

