/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepEndPointsObject;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepEndPointsObjectVer1
implements PcepEndPointsObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepEndPointsObjectVer1.class);
    static final byte END_POINTS_OBJ_TYPE = 1;
    static final byte END_POINTS_OBJ_CLASS = 4;
    static final byte END_POINTS_OBJECT_VERSION = 1;
    static final short END_POINTS_OBJ_MINIMUM_LENGTH = 12;
    static byte endPointObjType;
    static final PcepObjectHeader DEFAULT_END_POINTS_OBJECT_HEADER;
    private PcepObjectHeader endPointsObjHeader;
    int sourceIpAddress;
    int destIpAddress;

    public PcepEndPointsObjectVer1(PcepObjectHeader endPointsObjHeader, int sourceIpAddress, int destIpAddress) {
        this.endPointsObjHeader = endPointsObjHeader;
        this.sourceIpAddress = sourceIpAddress;
        this.destIpAddress = destIpAddress;
    }

    public void setEndPointsObjHeader(PcepObjectHeader obj) {
        this.endPointsObjHeader = obj;
    }

    @Override
    public void setSourceIpAddress(int sourceIpAddress) {
        this.sourceIpAddress = sourceIpAddress;
    }

    @Override
    public void setDestIpAddress(int destIpAddress) {
        this.destIpAddress = destIpAddress;
    }

    @Override
    public int getSourceIpAddress() {
        return this.sourceIpAddress;
    }

    @Override
    public int getDestIpAddress() {
        return this.destIpAddress;
    }

    public static PcepEndPointsObject read(ChannelBuffer cb) throws PcepParseException {
        PcepObjectHeader endPointsObjHeader = PcepObjectHeader.read(cb);
        if (endPointsObjHeader.getObjType() != 1 || endPointsObjHeader.getObjClass() != 4) {
            throw new PcepParseException("Expected PcepEndPointsObject.");
        }
        int sourceIpAddress = cb.readInt();
        int destIpAddress = cb.readInt();
        return new PcepEndPointsObjectVer1(endPointsObjHeader, sourceIpAddress, destIpAddress);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.endPointsObjHeader.write(cb);
        cb.writeInt(this.sourceIpAddress);
        cb.writeInt(this.destIpAddress);
        int length = cb.writerIndex() - objStartIndex;
        cb.setShort(objLenIndex, (int)((short)length));
        this.endPointsObjHeader.setObjLen((short)length);
        return cb.writerIndex();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("sourceIpAddress", this.sourceIpAddress).add("destIpAddress", this.destIpAddress).toString();
    }

    static {
        DEFAULT_END_POINTS_OBJECT_HEADER = new PcepObjectHeader(4, 1, false, false, 12);
    }

    public static class Builder
    implements PcepEndPointsObject.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsSourceIpAddressset = false;
        private boolean bIsDestIpAddressset = false;
        private PcepObjectHeader endpointsObjHeader;
        private int sourceIpAddress;
        private int destIpAddress;
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepEndPointsObject build() throws PcepParseException {
            PcepObjectHeader endpointsObjHeader;
            PcepObjectHeader pcepObjectHeader = endpointsObjHeader = this.bIsHeaderSet ? this.endpointsObjHeader : DEFAULT_END_POINTS_OBJECT_HEADER;
            if (this.bIsPFlagSet) {
                endpointsObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                endpointsObjHeader.setIFlag(this.bIFlag);
            }
            if (!this.bIsSourceIpAddressset) {
                throw new PcepParseException("SourceIpAddress not set while building EndPoints object");
            }
            if (!this.bIsDestIpAddressset) {
                throw new PcepParseException("DestIpAddress not set while building EndPoints object");
            }
            return new PcepEndPointsObjectVer1(endpointsObjHeader, this.sourceIpAddress, this.destIpAddress);
        }

        @Override
        public PcepObjectHeader getEndPointsObjHeader() {
            return this.endpointsObjHeader;
        }

        @Override
        public Builder setEndPointsObjHeader(PcepObjectHeader obj) {
            this.endpointsObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public int getSourceIpAddress() {
            return this.sourceIpAddress;
        }

        @Override
        public Builder setSourceIpAddress(int sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
            this.bIsSourceIpAddressset = true;
            return this;
        }

        @Override
        public int getDestIpAddress() {
            return this.destIpAddress;
        }

        @Override
        public Builder setDestIpAddress(int destIpAddress) {
            this.destIpAddress = destIpAddress;
            this.bIsDestIpAddressset = true;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

