/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepCloseMsg;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepMessageWriter;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PcepCloseMsgVer1
implements PcepCloseMsg {
    protected static final Logger log = LoggerFactory.getLogger(PcepCloseMsgVer1.class);
    public static final byte PACKET_VERSION = 1;
    public static final int PACKET_MINIMUM_LENGTH = 12;
    public static final PcepType MSG_TYPE = PcepType.CLOSE;
    public static final byte CLOSE_OBJ_TYPE = 1;
    public static final byte CLOSE_OBJ_CLASS = 15;
    public static final byte CLOSE_OBJECT_VERSION = 1;
    public static final byte DEFAULT_REASON = 1;
    public static final short CLOSE_OBJ_MINIMUM_LENGTH = 8;
    public static final int SHIFT_FLAG = 5;
    static final PcepObjectHeader DEFAULT_CLOSE_HEADER = new PcepObjectHeader(15, 1, false, false, 8);
    private final PcepObjectHeader closeObjHeader;
    private byte yReason;
    private LinkedList<PcepValueType> llOptionalTlv;
    public static final Reader READER = new Reader();
    static final Writer WRITER = new Writer();

    public static LinkedList<PcepValueType> parseOptionalTlv(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOptionalTlv = new LinkedList<PcepValueType>();
        return llOptionalTlv;
    }

    PcepCloseMsgVer1(PcepObjectHeader closeObjHeader, byte yReason, LinkedList<PcepValueType> llOptionalTlv) {
        this.closeObjHeader = closeObjHeader;
        this.yReason = yReason;
        this.llOptionalTlv = llOptionalTlv;
    }

    @Override
    public void writeTo(ChannelBuffer cb) throws PcepParseException {
        WRITER.write(cb, this);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public PcepType getType() {
        return MSG_TYPE;
    }

    @Override
    public byte getReason() {
        return this.yReason;
    }

    @Override
    public void setReason(byte value) {
        this.yReason = value;
    }

    @Override
    public LinkedList<PcepValueType> getOptionalTlv() {
        return this.llOptionalTlv;
    }

    @Override
    public void setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
        this.llOptionalTlv = llOptionalTlv;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("closeObjectHeader", (Object)this.closeObjHeader).add("Reason", (int)this.yReason).add("OptionalTlvlist", this.llOptionalTlv).toString();
    }

    static class Writer
    implements PcepMessageWriter<PcepCloseMsgVer1> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer cb, PcepCloseMsgVer1 message) throws PcepParseException {
            int startIndex = cb.writerIndex();
            cb.writeByte(32);
            cb.writeByte((int)MSG_TYPE.getType());
            int msgLenIndex = cb.writerIndex();
            cb.writeShort(0);
            int objStartIndex = cb.writerIndex();
            int objLenIndex = message.closeObjHeader.write(cb);
            if (objLenIndex <= 0) {
                throw new PcepParseException("Failed to write Close object header.");
            }
            cb.writeShort(0);
            cb.writeByte(0);
            cb.writeByte((int)message.yReason);
            this.packOptionalTlv(cb, message);
            int length = cb.writerIndex() - objStartIndex;
            cb.setShort(objLenIndex, (int)((short)length));
            message.closeObjHeader.setObjLen((short)length);
            int pad = length % 4;
            if (pad != 0) {
                pad = 4 - pad;
                for (int i = 0; i < pad; ++i) {
                    cb.writeByte(0);
                }
                length += pad;
            }
            length = cb.writerIndex() - startIndex;
            cb.setShort(msgLenIndex, (int)((short)length));
        }

        public void packOptionalTlv(ChannelBuffer cb, PcepCloseMsgVer1 message) {
            LinkedList llOptionalTlv = message.llOptionalTlv;
            ListIterator listIterator = llOptionalTlv.listIterator();
            while (listIterator.hasNext()) {
                ((PcepValueType)listIterator.next()).write(cb);
            }
        }
    }

    static class Builder
    implements PcepCloseMsg.Builder {
        private boolean bIsHeaderSet = false;
        private PcepObjectHeader closeObjHeader;
        private boolean bIsReasonSet = false;
        private byte yReason;
        private LinkedList<PcepValueType> llOptionalTlv = new LinkedList();
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        Builder() {
        }

        @Override
        public PcepVersion getVersion() {
            return PcepVersion.PCEP_1;
        }

        @Override
        public PcepType getType() {
            return PcepType.CLOSE;
        }

        @Override
        public PcepCloseMsg build() {
            byte yReason;
            PcepObjectHeader closeObjHeader = this.bIsHeaderSet ? this.closeObjHeader : DEFAULT_CLOSE_HEADER;
            byte by = yReason = this.bIsReasonSet ? this.yReason : (byte)1;
            if (this.bIsPFlagSet) {
                closeObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                closeObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepCloseMsgVer1(closeObjHeader, yReason, this.llOptionalTlv);
        }

        @Override
        public PcepObjectHeader getCloseObjHeader() {
            return this.closeObjHeader;
        }

        @Override
        public Builder setCloseObjHeader(PcepObjectHeader obj) {
            this.closeObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public byte getReason() {
            return this.yReason;
        }

        @Override
        public Builder setReason(byte value) {
            this.yReason = value;
            this.bIsReasonSet = true;
            return this;
        }

        @Override
        public Builder setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
            this.llOptionalTlv = llOptionalTlv;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getOptionalTlv() {
            return this.llOptionalTlv;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }

    static class Reader
    implements PcepMessageReader<PcepCloseMsg> {
        PcepObjectHeader closeObjHeader;
        byte yReason;
        private LinkedList<PcepValueType> llOptionalTlv;

        Reader() {
        }

        @Override
        public PcepCloseMsg readFrom(ChannelBuffer cb) throws PcepParseException {
            if (cb.readableBytes() < 12) {
                throw new PcepParseException("Packet size is less than the minimum length.");
            }
            byte version = cb.readByte();
            if ((version = (byte)(version >> 5)) != 1) {
                throw new PcepParseException("Wrong version. Expected=PcepVersion.PCEP_1(1), got=" + version);
            }
            byte type = cb.readByte();
            if (type != MSG_TYPE.getType()) {
                throw new PcepParseException("Wrong type. Expected=PcepType.CLOSE(7), got=" + type);
            }
            short length = cb.readShort();
            if (length < 12) {
                throw new PcepParseException("Wrong length. Expected to be >= 12, was: " + length);
            }
            this.closeObjHeader = PcepObjectHeader.read(cb);
            cb.readShort();
            cb.readByte();
            this.yReason = cb.readByte();
            this.llOptionalTlv = PcepCloseMsgVer1.parseOptionalTlv(cb);
            return new PcepCloseMsgVer1(this.closeObjHeader, this.yReason, this.llOptionalTlv);
        }
    }
}

