/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepBandwidthObject;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepBandwidthObjectVer1
implements PcepBandwidthObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepBandwidthObjectVer1.class);
    public static final byte BANDWIDTH_OBJ_TYPE = 1;
    public static final byte BANDWIDTH_OBJ_CLASS = 5;
    public static final byte BANDWIDTH_OBJECT_VERSION = 1;
    public static final int NO_OF_BITS = 8;
    public static final short BANDWIDTH_OBJ_MINIMUM_LENGTH = 8;
    static final PcepObjectHeader DEFAULT_BANDWIDTH_OBJECT_HEADER = new PcepObjectHeader(5, 1, false, false, 8);
    private PcepObjectHeader bandwidthObjHeader;
    private float iBandwidth;

    public PcepBandwidthObjectVer1(PcepObjectHeader bandwidthObjHeader, float iBandwidth) {
        this.bandwidthObjHeader = bandwidthObjHeader;
        this.iBandwidth = iBandwidth;
    }

    public PcepBandwidthObjectVer1(float iBandwidth) {
        this.bandwidthObjHeader = DEFAULT_BANDWIDTH_OBJECT_HEADER;
        this.iBandwidth = iBandwidth;
    }

    public PcepObjectHeader getBandwidthObjHeader() {
        return this.bandwidthObjHeader;
    }

    public void setBandwidthObjHeader(PcepObjectHeader obj) {
        this.bandwidthObjHeader = obj;
    }

    @Override
    public float getBandwidth() {
        return this.iBandwidth;
    }

    @Override
    public void setBandwidth(float iBandwidth) {
        this.iBandwidth = iBandwidth;
    }

    public static PcepBandwidthObject read(ChannelBuffer cb) throws PcepParseException {
        PcepObjectHeader bandwidthObjHeader = PcepObjectHeader.read(cb);
        float bandwidth = PcepBandwidthObjectVer1.ieeeToFloatRead(cb.readInt()) * 8.0f;
        return new PcepBandwidthObjectVer1(bandwidthObjHeader, bandwidth);
    }

    public static float ieeeToFloatRead(int iVal) {
        return Float.intBitsToFloat(iVal);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.bandwidthObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException("Failed to write bandwidth object header. Index " + objLenIndex);
        }
        float bwBytes = this.iBandwidth / 8.0f;
        int bandwidth = Float.floatToIntBits(bwBytes);
        cb.writeByte(bandwidth >>> 24);
        cb.writeByte(bandwidth >> 16 & 0xFF);
        cb.writeByte(bandwidth >> 8 & 0xFF);
        cb.writeByte(bandwidth & 0xFF);
        short hLength = (short)(cb.writerIndex() - objStartIndex);
        cb.setShort(objLenIndex, (int)hLength);
        this.bandwidthObjHeader.setObjLen(hLength);
        return cb.writerIndex() - objStartIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("BandwidthObjectHeader", (Object)this.bandwidthObjHeader).add("Bandwidth", this.iBandwidth).toString();
    }

    public static class Builder
    implements PcepBandwidthObject.Builder {
        private PcepObjectHeader bandwidthObjHeader;
        private boolean bIsHeaderSet = false;
        private float iBandwidth;
        private boolean bIsBandwidthSet = false;
        private boolean bPFlag;
        private boolean bIsPFlagSet = false;
        private boolean bIFlag;
        private boolean bIsIFlagSet = false;

        @Override
        public PcepBandwidthObject build() throws PcepParseException {
            PcepObjectHeader bandwidthObjHeader;
            PcepObjectHeader pcepObjectHeader = bandwidthObjHeader = this.bIsHeaderSet ? this.bandwidthObjHeader : DEFAULT_BANDWIDTH_OBJECT_HEADER;
            if (this.bIsPFlagSet) {
                bandwidthObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                bandwidthObjHeader.setIFlag(this.bIFlag);
            }
            if (!this.bIsBandwidthSet) {
                throw new PcepParseException("bandwidth not Set while building Bandwidth Object.");
            }
            return new PcepBandwidthObjectVer1(bandwidthObjHeader, this.iBandwidth);
        }

        @Override
        public float getBandwidth() {
            return this.iBandwidth;
        }

        @Override
        public PcepObjectHeader getBandwidthObjHeader() {
            return this.bandwidthObjHeader;
        }

        @Override
        public Builder setBandwidthObjHeader(PcepObjectHeader obj) {
            this.bandwidthObjHeader = obj;
            return this;
        }

        @Override
        public Builder setBandwidth(float iBandwidth) {
            this.iBandwidth = iBandwidth;
            this.bIsBandwidthSet = true;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

