/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepAttribute;
import org.onosproject.pcepio.protocol.PcepBandwidthObject;
import org.onosproject.pcepio.protocol.PcepIroObject;
import org.onosproject.pcepio.protocol.PcepLspaObject;
import org.onosproject.pcepio.protocol.PcepMetricObject;
import org.onosproject.pcepio.protocol.ver1.PcepBandwidthObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepIroObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepLspaObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepMetricObjectVer1;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepAttributeVer1
implements PcepAttribute {
    protected static final Logger log = LoggerFactory.getLogger(PcepAttributeVer1.class);
    public static final int OBJECT_HEADER_LENGTH = 4;
    private PcepLspaObject lspaObject;
    private boolean isLspaObjectSet;
    private PcepBandwidthObject bandwidthObject;
    private boolean isBandwidthObjectSet;
    private LinkedList<PcepMetricObject> llMetricList;
    private boolean isMetricListSet;
    private PcepIroObject iroObject;
    private boolean isIroObjectSet;

    public PcepAttributeVer1() {
        this.lspaObject = null;
        this.bandwidthObject = null;
        this.llMetricList = null;
        this.iroObject = null;
        this.isLspaObjectSet = false;
        this.isBandwidthObjectSet = false;
        this.isMetricListSet = false;
        this.isIroObjectSet = false;
    }

    public PcepAttributeVer1(PcepLspaObject lspaObject, PcepBandwidthObject bandwidthObject, LinkedList<PcepMetricObject> llMetricList, PcepIroObject iroObject) {
        this.lspaObject = lspaObject;
        this.bandwidthObject = bandwidthObject;
        this.llMetricList = llMetricList;
        this.iroObject = iroObject;
        this.isLspaObjectSet = lspaObject != null;
        this.isBandwidthObjectSet = bandwidthObject != null;
        this.isMetricListSet = llMetricList != null;
        this.isIroObjectSet = iroObject != null;
    }

    public PcepAttributeVer1(PcepBandwidthObject bandwidthObject) {
        this.isLspaObjectSet = false;
        this.bandwidthObject = bandwidthObject;
        this.isBandwidthObjectSet = true;
        this.isMetricListSet = false;
        this.isIroObjectSet = false;
    }

    public boolean parseMetricList(ChannelBuffer cb) throws PcepParseException {
        if (this.llMetricList == null) {
            this.llMetricList = new LinkedList();
        }
        int yObjClass = 6;
        byte yObjType = 1;
        while (yObjClass == 6 && yObjType == 1) {
            PcepMetricObject metriclist = PcepMetricObjectVer1.read(cb);
            this.llMetricList.add(metriclist);
            yObjClass = 0;
            yObjType = 0;
            if (cb.readableBytes() <= 4) continue;
            cb.markReaderIndex();
            PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
            cb.resetReaderIndex();
            yObjClass = tempObjHeader.getObjClass();
            yObjType = tempObjHeader.getObjType();
        }
        return true;
    }

    public static PcepAttribute read(ChannelBuffer cb) throws PcepParseException {
        if (cb.readableBytes() < 4) {
            return null;
        }
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        byte yObjClass = tempObjHeader.getObjClass();
        if (9 != yObjClass && 5 != yObjClass && 6 != yObjClass && 10 != yObjClass) {
            return null;
        }
        PcepAttributeVer1 pcepAttribute = new PcepAttributeVer1();
        if (yObjClass == 9) {
            pcepAttribute.setLspaObject(PcepLspaObjectVer1.read(cb));
            yObjClass = PcepAttributeVer1.checkNextObject(cb);
        }
        if (yObjClass == 5) {
            pcepAttribute.setBandwidthObject(PcepBandwidthObjectVer1.read(cb));
            yObjClass = PcepAttributeVer1.checkNextObject(cb);
        }
        if (yObjClass == 6) {
            pcepAttribute.parseMetricList(cb);
            yObjClass = PcepAttributeVer1.checkNextObject(cb);
        }
        if (yObjClass == 10) {
            pcepAttribute.setIroObject(PcepIroObjectVer1.read(cb));
        }
        PcepLspaObject lspaObject = pcepAttribute.getLspaObject();
        PcepBandwidthObject bandwidthObject = pcepAttribute.getBandwidthObject();
        LinkedList<PcepMetricObject> metriclist = pcepAttribute.llMetricList;
        PcepIroObject iroObject = pcepAttribute.getIroObject();
        return new PcepAttributeVer1(lspaObject, bandwidthObject, metriclist, iroObject);
    }

    private static byte checkNextObject(ChannelBuffer cb) {
        if (cb.readableBytes() < 4) {
            return 0;
        }
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        return tempObjHeader.getObjClass();
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int iLenStartIndex = cb.writerIndex();
        if (this.isLspaObjectSet) {
            this.lspaObject.write(cb);
        }
        if (this.isBandwidthObjectSet) {
            this.bandwidthObject.write(cb);
        }
        if (this.isMetricListSet) {
            ListIterator listIterator = this.llMetricList.listIterator();
            while (listIterator.hasNext()) {
                ((PcepMetricObject)listIterator.next()).write(cb);
            }
        }
        if (this.isIroObjectSet) {
            this.iroObject.write(cb);
        }
        return cb.writerIndex() - iLenStartIndex;
    }

    @Override
    public PcepLspaObject getLspaObject() {
        return this.lspaObject;
    }

    @Override
    public PcepBandwidthObject getBandwidthObject() {
        return this.bandwidthObject;
    }

    @Override
    public LinkedList<PcepMetricObject> getMetricObjectList() {
        return this.llMetricList;
    }

    @Override
    public PcepIroObject getIroObject() {
        return this.iroObject;
    }

    @Override
    public void setBandwidthObject(PcepBandwidthObject bandwidthObject) {
        this.isBandwidthObjectSet = true;
        this.bandwidthObject = bandwidthObject;
    }

    @Override
    public void setMetricObjectList(LinkedList<PcepMetricObject> llMetricList) {
        this.isMetricListSet = true;
        this.llMetricList = llMetricList;
    }

    @Override
    public void setLspaObject(PcepLspaObject lspaObject) {
        this.isLspaObjectSet = true;
        this.lspaObject = lspaObject;
    }

    @Override
    public void setIroObject(PcepIroObject iroObject) {
        this.isIroObjectSet = true;
        this.iroObject = iroObject;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("lspaObject", (Object)this.lspaObject).add("bandwidthObject", (Object)this.bandwidthObject).add("MetricObjectList", this.llMetricList).add("IroObject", (Object)this.iroObject).toString();
    }

    public static class Builder
    implements PcepAttribute.Builder {
        private PcepLspaObject lspaObject;
        private boolean isLspaObjectSet;
        private PcepBandwidthObject bandwidthObject;
        private boolean isBandwidthObjectSet;
        private LinkedList<PcepMetricObject> llMetricList;
        private boolean isMetricListSet;
        private PcepIroObject iroObject;
        private boolean isIroObjectSet;

        @Override
        public PcepAttribute build() {
            PcepLspaObject lspaObject = null;
            PcepBandwidthObject bandwidthObject = null;
            LinkedList<PcepMetricObject> llMetricList = null;
            PcepIroObject iroObject = null;
            if (this.isLspaObjectSet) {
                lspaObject = this.lspaObject;
            }
            if (this.isBandwidthObjectSet) {
                bandwidthObject = this.bandwidthObject;
            }
            if (this.isMetricListSet) {
                llMetricList = this.llMetricList;
            }
            if (this.isIroObjectSet) {
                iroObject = this.iroObject;
            }
            return new PcepAttributeVer1(lspaObject, bandwidthObject, llMetricList, iroObject);
        }

        @Override
        public PcepLspaObject getLspaObject() {
            return this.lspaObject;
        }

        @Override
        public PcepBandwidthObject getBandwidthObject() {
            return this.bandwidthObject;
        }

        @Override
        public LinkedList<PcepMetricObject> getMetricObjectList() {
            return this.llMetricList;
        }

        @Override
        public PcepIroObject getIroObject() {
            return this.iroObject;
        }

        @Override
        public Builder setBandwidthObject(PcepBandwidthObject bandwidthObject) {
            this.isBandwidthObjectSet = true;
            this.bandwidthObject = bandwidthObject;
            return this;
        }

        @Override
        public Builder setMetricObjectList(LinkedList<PcepMetricObject> llMetricList) {
            this.isMetricListSet = true;
            this.llMetricList = llMetricList;
            return this;
        }

        @Override
        public Builder setLspaObject(PcepLspaObject lspaObject) {
            this.isLspaObjectSet = true;
            this.lspaObject = lspaObject;
            return this;
        }

        @Override
        public Builder setIroObject(PcepIroObject iroObject) {
            this.isIroObjectSet = true;
            this.iroObject = iroObject;
            return this;
        }
    }
}

