/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcInitiatedLspRequest;
import org.onosproject.pcepio.protocol.PcepAttribute;
import org.onosproject.pcepio.protocol.PcepEndPointsObject;
import org.onosproject.pcepio.protocol.PcepEroObject;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcInitiatedLspRequestVer1
implements PcInitiatedLspRequest {
    protected static final Logger log = LoggerFactory.getLogger(PcInitiatedLspRequestVer1.class);
    private PcepSrpObject srpObject;
    private PcepLspObject lspObject;
    private PcepEndPointsObject endPointsObject;
    private PcepEroObject eroObject;
    private PcepAttribute pcepAttribute;

    public PcInitiatedLspRequestVer1() {
        this.srpObject = null;
        this.lspObject = null;
        this.endPointsObject = null;
        this.eroObject = null;
        this.pcepAttribute = null;
    }

    public PcInitiatedLspRequestVer1(PcepSrpObject srpObject, PcepLspObject lspObject, PcepEndPointsObject endPointsObject, PcepEroObject eroObject, PcepAttribute pcepAttribute) {
        this.srpObject = srpObject;
        this.lspObject = lspObject;
        this.endPointsObject = endPointsObject;
        this.eroObject = eroObject;
        this.pcepAttribute = pcepAttribute;
    }

    @Override
    public PcepSrpObject getSrpObject() {
        return this.srpObject;
    }

    @Override
    public PcepLspObject getLspObject() {
        return this.lspObject;
    }

    @Override
    public PcepEndPointsObject getEndPointsObject() {
        return this.endPointsObject;
    }

    @Override
    public PcepEroObject getEroObject() {
        return this.eroObject;
    }

    @Override
    public PcepAttribute getPcepAttribute() {
        return this.pcepAttribute;
    }

    @Override
    public void setSrpObject(PcepSrpObject srpobj) {
        this.srpObject = srpobj;
    }

    @Override
    public void setLspObject(PcepLspObject lspObject) {
        this.lspObject = lspObject;
    }

    @Override
    public void setEndPointsObject(PcepEndPointsObject endPointsObject) {
        this.endPointsObject = endPointsObject;
    }

    @Override
    public void setEroObject(PcepEroObject eroObject) {
        this.eroObject = eroObject;
    }

    @Override
    public void setPcepAttribute(PcepAttribute pcepAttribute) {
        this.pcepAttribute = pcepAttribute;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("SrpObject", (Object)this.srpObject).add("LspObject", (Object)this.lspObject).add("EndPointObject", (Object)this.endPointsObject).add("EroObject", (Object)this.eroObject).add("PcepAttribute", (Object)this.pcepAttribute).toString();
    }

    public static class Builder
    implements PcInitiatedLspRequest.Builder {
        private boolean bIsSrpObjectSet = false;
        private boolean bIsLspObjectSet = false;
        private boolean bIsEndPointsObjectSet = false;
        private boolean bIsEroObjectSet = false;
        private boolean bIsPcepAttributeSet = false;
        private boolean bIsbRFlagSet = false;
        private PcepSrpObject srpObject;
        private PcepLspObject lspObject;
        private PcepEndPointsObject endPointsObject;
        private PcepEroObject eroObject;
        private PcepAttribute pcepAttribute;

        @Override
        public PcInitiatedLspRequest build() throws PcepParseException {
            PcepSrpObject srpObject = null;
            PcepLspObject lspObject = null;
            PcepEndPointsObject endPointsObject = null;
            PcepEroObject eroObject = null;
            PcepAttribute pcepAttribute = null;
            boolean bRFlag = false;
            if (!this.bIsSrpObjectSet) {
                throw new PcepParseException("Srp object NOT Set while building PcInitiatedLspRequest");
            }
            srpObject = this.srpObject;
            bRFlag = srpObject.getRFlag();
            this.bIsbRFlagSet = bRFlag;
            if (!this.bIsLspObjectSet) {
                throw new PcepParseException("LSP Object NOT Set while building PcInitiatedLspRequest");
            }
            lspObject = this.lspObject;
            if (!this.bIsbRFlagSet) {
                if (!this.bIsEndPointsObjectSet) {
                    throw new PcepParseException("EndPoints Object NOT Set while building PcInitiatedLspRequest");
                }
                endPointsObject = this.endPointsObject;
                if (!this.bIsEroObjectSet) {
                    throw new PcepParseException("ERO Object NOT Set while building PcInitiatedLspRequest");
                }
                eroObject = this.eroObject;
                if (this.bIsPcepAttributeSet) {
                    pcepAttribute = this.pcepAttribute;
                }
            }
            return new PcInitiatedLspRequestVer1(srpObject, lspObject, endPointsObject, eroObject, pcepAttribute);
        }

        @Override
        public PcepSrpObject getSrpObject() {
            return this.srpObject;
        }

        @Override
        public PcepLspObject getLspObject() {
            return this.lspObject;
        }

        @Override
        public PcepEndPointsObject getEndPointsObject() {
            return this.endPointsObject;
        }

        @Override
        public PcepEroObject getEroObject() {
            return this.eroObject;
        }

        @Override
        public PcepAttribute getPcepAttribute() {
            return this.pcepAttribute;
        }

        @Override
        public Builder setSrpObject(PcepSrpObject srpobj) {
            this.srpObject = srpobj;
            this.bIsSrpObjectSet = true;
            return this;
        }

        @Override
        public Builder setLspObject(PcepLspObject lspObject) {
            this.lspObject = lspObject;
            this.bIsLspObjectSet = true;
            return this;
        }

        @Override
        public Builder setEndPointsObject(PcepEndPointsObject endPointsObject) {
            this.endPointsObject = endPointsObject;
            this.bIsEndPointsObjectSet = true;
            return this;
        }

        @Override
        public Builder setEroObject(PcepEroObject eroObject) {
            this.eroObject = eroObject;
            this.bIsEroObjectSet = true;
            return this;
        }

        @Override
        public Builder setPcepAttribute(PcepAttribute pcepAttribute) {
            this.pcepAttribute = pcepAttribute;
            this.bIsPcepAttributeSet = true;
            return this;
        }
    }
}

