/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol;

import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepOutOfBoundMessageException;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFactory;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.protocol.ver1.PcepFactoryVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcepFactories {
    protected static final Logger log = LoggerFactory.getLogger(PcepFactories.class);
    private static final GenericReader GENERIC_READER = new GenericReader();
    public static final byte SHIFT_FLAG = 5;

    private PcepFactories() {
    }

    public static PcepFactory getFactory(PcepVersion version) {
        switch (version) {
            case PCEP_1: {
                return PcepFactoryVer1.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unknown version: " + (Object)((Object)version));
    }

    public static PcepMessageReader<PcepMessage> getGenericReader() {
        return GENERIC_READER;
    }

    private static class GenericReader
    implements PcepMessageReader<PcepMessage> {
        private GenericReader() {
        }

        @Override
        public PcepMessage readFrom(ChannelBuffer bb) throws PcepParseException, PcepOutOfBoundMessageException {
            PcepFactoryVer1 factory;
            if (!bb.readable()) {
                throw new PcepParseException("Empty message received");
            }
            byte packetVersion = bb.getByte(bb.readerIndex());
            packetVersion = (byte)(packetVersion >> 5);
            switch (packetVersion) {
                case 1: {
                    factory = PcepFactoryVer1.INSTANCE;
                    break;
                }
                default: {
                    throw new PcepParseException("Unknown Packet version: " + packetVersion);
                }
            }
            return factory.getReader().readFrom(bb);
        }
    }
}

