/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.drivers.lisp.extensions.LispTeAddress;
import org.onosproject.mapping.addresses.MappingAddress;

public final class LispTeRecordCodec
extends JsonCodec<LispTeAddress.TeRecord> {
    protected static final String LOOKUP = "lookup";
    protected static final String RLOC_PROBE = "rlocProbe";
    protected static final String STRICT = "strict";
    protected static final String ADDRESS = "address";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in LispTeRecord";

    public ObjectNode encode(LispTeAddress.TeRecord record, CodecContext context) {
        Preconditions.checkNotNull((Object)record, (Object)"LispTeRecord cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(LOOKUP, record.isLookup()).put(RLOC_PROBE, record.isRlocProbe()).put(STRICT, record.isStrict());
        if (record.getAddress() != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            ObjectNode address = addressCodec.encode((Object)record.getAddress(), context);
            result.set(ADDRESS, (JsonNode)address);
        }
        return result;
    }

    public LispTeAddress.TeRecord decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        boolean isLookup = ((JsonNode)Tools.nullIsIllegal((Object)json.get(LOOKUP), (String)"lookup member is required in LispTeRecord")).asBoolean();
        boolean isRlocProbe = ((JsonNode)Tools.nullIsIllegal((Object)json.get(RLOC_PROBE), (String)"rlocProbe member is required in LispTeRecord")).asBoolean();
        boolean isStrict = ((JsonNode)Tools.nullIsIllegal((Object)json.get(STRICT), (String)"strict member is required in LispTeRecord")).asBoolean();
        ObjectNode addressJson = LispTeRecordCodec.get((ObjectNode)json, (String)ADDRESS);
        MappingAddress mappingAddress = null;
        if (addressJson != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            mappingAddress = (MappingAddress)addressCodec.decode(addressJson, context);
        }
        return new LispTeAddress.TeRecord.Builder().withIsLookup(isLookup).withIsRlocProbe(isRlocProbe).withIsStrict(isStrict).withRtrRlocAddress(mappingAddress).build();
    }
}

