/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.drivers.lisp.extensions.LispTeAddress;

public final class LispTeAddressCodec
extends JsonCodec<LispTeAddress> {
    protected static final String TE_RECORDS = "records";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in LispTeAddress";

    public ObjectNode encode(LispTeAddress address, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)address), (Object)"LispTeAddress cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        ArrayNode jsonRecords = result.putArray(TE_RECORDS);
        JsonCodec recordCodec = context.codec(LispTeAddress.TeRecord.class);
        for (LispTeAddress.TeRecord record : address.getTeRecords()) {
            jsonRecords.add((JsonNode)recordCodec.encode((Object)record, context));
        }
        return result;
    }

    public LispTeAddress decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        JsonCodec recordCodec = context.codec(LispTeAddress.TeRecord.class);
        JsonNode recordsJson = (JsonNode)Tools.nullIsIllegal((Object)json.get(TE_RECORDS), (String)"records member is required in LispTeAddress");
        ArrayList records = Lists.newArrayList();
        if (recordsJson != null) {
            IntStream.range(0, recordsJson.size()).forEach(i -> records.add(recordCodec.decode(LispTeAddressCodec.get((JsonNode)recordsJson, (int)i), context)));
        }
        return new LispTeAddress.Builder().withTeRecords(records).build();
    }
}

