/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.drivers.lisp.extensions.LispSrcDstAddress;
import org.onosproject.mapping.addresses.MappingAddress;

public final class LispSrcDstAddressCodec
extends JsonCodec<LispSrcDstAddress> {
    protected static final String SRC_MASK_LENGTH = "srcMaskLength";
    protected static final String DST_MASK_LENGTH = "dstMaskLength";
    protected static final String SRC_PREFIX = "srcPrefix";
    protected static final String DST_PREFIX = "dstPrefix";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in LispSrcDstAddress";

    public ObjectNode encode(LispSrcDstAddress address, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)address), (Object)"LispSrcDstAddress cannot be null");
        JsonCodec addressCodec = context.codec(MappingAddress.class);
        ObjectNode result = context.mapper().createObjectNode().put(SRC_MASK_LENGTH, (short)address.getSrcMaskLength()).put(DST_MASK_LENGTH, (short)address.getDstMaskLength());
        if (address.getSrcPrefix() != null) {
            ObjectNode srcPrefix = addressCodec.encode((Object)address.getSrcPrefix(), context);
            result.set(SRC_PREFIX, (JsonNode)srcPrefix);
        }
        if (address.getDstPrefix() != null) {
            ObjectNode dstPrefix = addressCodec.encode((Object)address.getDstPrefix(), context);
            result.set(DST_PREFIX, (JsonNode)dstPrefix);
        }
        return result;
    }

    public LispSrcDstAddress decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        byte srcMaskLength = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get(SRC_MASK_LENGTH), (String)"srcMaskLength member is required in LispSrcDstAddress")).asInt();
        byte dstMaskLength = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get(DST_MASK_LENGTH), (String)"dstMaskLength member is required in LispSrcDstAddress")).asInt();
        JsonCodec addressCodec = context.codec(MappingAddress.class);
        ObjectNode srcPrefixJson = LispSrcDstAddressCodec.get((ObjectNode)json, (String)SRC_PREFIX);
        MappingAddress srcPrefix = null;
        ObjectNode dstPrefixJson = LispSrcDstAddressCodec.get((ObjectNode)json, (String)DST_PREFIX);
        MappingAddress dstPrefix = null;
        if (srcPrefixJson != null) {
            srcPrefix = (MappingAddress)addressCodec.decode(srcPrefixJson, context);
        }
        if (dstPrefixJson != null) {
            dstPrefix = (MappingAddress)addressCodec.decode(dstPrefixJson, context);
        }
        return new LispSrcDstAddress.Builder().withSrcMaskLength(srcMaskLength).withDstMaskLength(dstMaskLength).withSrcPrefix(srcPrefix).withDstPrefix(dstPrefix).build();
    }
}

