/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.drivers.lisp.extensions.LispSegmentAddress;
import org.onosproject.mapping.addresses.MappingAddress;

public final class LispSegmentAddressCodec
extends JsonCodec<LispSegmentAddress> {
    protected static final String INSTANCE_ID = "instanceId";
    protected static final String ADDRESS = "address";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in LispSegmentAddress";

    public ObjectNode encode(LispSegmentAddress address, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)address), (Object)"LispSegmentAddress cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(INSTANCE_ID, address.getInstanceId());
        if (address.getAddress() != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            ObjectNode addressNode = addressCodec.encode((Object)address.getAddress(), context);
            result.set(ADDRESS, (JsonNode)addressNode);
        }
        return result;
    }

    public LispSegmentAddress decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        int instanceId = ((JsonNode)Tools.nullIsIllegal((Object)json.get(INSTANCE_ID), (String)"instanceId member is required in LispSegmentAddress")).asInt();
        ObjectNode addressJson = LispSegmentAddressCodec.get((ObjectNode)json, (String)ADDRESS);
        MappingAddress mappingAddress = null;
        if (addressJson != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            mappingAddress = (MappingAddress)addressCodec.decode(addressJson, context);
        }
        return new LispSegmentAddress.Builder().withInstanceId(instanceId).withAddress(mappingAddress).build();
    }
}

