/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.drivers.lisp.extensions.LispNonceAddress;
import org.onosproject.mapping.addresses.MappingAddress;

public final class LispNonceAddressCodec
extends JsonCodec<LispNonceAddress> {
    protected static final String NONCE = "nonce";
    protected static final String ADDRESS = "address";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in LispGcAddress";

    public ObjectNode encode(LispNonceAddress address, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)address), (Object)"LispListAddress cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(NONCE, address.getNonce());
        if (address.getAddress() != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            ObjectNode addressNode = addressCodec.encode((Object)address.getAddress(), context);
            result.set(ADDRESS, (JsonNode)addressNode);
        }
        return result;
    }

    public LispNonceAddress decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        int nonce = ((JsonNode)Tools.nullIsIllegal((Object)json.get(NONCE), (String)"nonce member is required in LispGcAddress")).asInt();
        ObjectNode addressJson = LispNonceAddressCodec.get((ObjectNode)json, (String)ADDRESS);
        MappingAddress mappingAddress = null;
        if (addressJson != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            mappingAddress = (MappingAddress)addressCodec.decode(addressJson, context);
        }
        return new LispNonceAddress.Builder().withNonce(nonce).withAddress(mappingAddress).build();
    }
}

