/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.drivers.lisp.extensions.LispNatAddress;
import org.onosproject.mapping.addresses.MappingAddress;

public final class LispNatAddressCodec
extends JsonCodec<LispNatAddress> {
    protected static final String MS_UDP_PORT_NUMBER = "msUdpPortNumber";
    protected static final String ETR_UDP_PORT_NUMBER = "etrUdpPortNumber";
    protected static final String GLOBAL_ETR_RLOC_ADDRESS = "globalEtrRlocAddress";
    protected static final String MS_RLOC_ADDRESS = "msRlocAddress";
    protected static final String PRIVATE_ETR_RLOC_ADDRESS = "privateEtrRlocAddress";
    protected static final String RTR_RLOC_ADDRESSES = "rtrRlocAddresses";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in LispListAddress";

    public ObjectNode encode(LispNatAddress address, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)address), (Object)"LispListAddress cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(MS_UDP_PORT_NUMBER, address.getMsUdpPortNumber()).put(ETR_UDP_PORT_NUMBER, address.getEtrUdpPortNumber());
        JsonCodec addressCodec = context.codec(MappingAddress.class);
        if (address.getGlobalEtrRlocAddress() != null) {
            ObjectNode globalEtrRlocNode = addressCodec.encode((Object)address.getGlobalEtrRlocAddress(), context);
            result.set(GLOBAL_ETR_RLOC_ADDRESS, (JsonNode)globalEtrRlocNode);
        }
        if (address.getMsRlocAddress() != null) {
            ObjectNode msRlocNode = addressCodec.encode((Object)address.getMsRlocAddress(), context);
            result.set(MS_RLOC_ADDRESS, (JsonNode)msRlocNode);
        }
        if (address.getPrivateEtrRlocAddress() != null) {
            ObjectNode privateEtrRlocNode = addressCodec.encode((Object)address.getPrivateEtrRlocAddress(), context);
            result.set(PRIVATE_ETR_RLOC_ADDRESS, (JsonNode)privateEtrRlocNode);
        }
        ArrayNode jsonRtrRlocNodes = result.putArray(RTR_RLOC_ADDRESSES);
        if (address.getRtrRlocAddresses() != null) {
            for (MappingAddress mappingAddress : address.getRtrRlocAddresses()) {
                jsonRtrRlocNodes.add((JsonNode)addressCodec.encode((Object)mappingAddress, context));
            }
        }
        return result;
    }

    public LispNatAddress decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        JsonCodec addressCodec = context.codec(MappingAddress.class);
        short msUdpPortNumber = (short)json.get(MS_UDP_PORT_NUMBER).asInt();
        short etrUdpPortNumber = (short)json.get(ETR_UDP_PORT_NUMBER).asInt();
        ObjectNode globalEtrRlocJson = LispNatAddressCodec.get((ObjectNode)json, (String)GLOBAL_ETR_RLOC_ADDRESS);
        ObjectNode msRlocJson = LispNatAddressCodec.get((ObjectNode)json, (String)MS_RLOC_ADDRESS);
        ObjectNode privateEtrRlocJson = LispNatAddressCodec.get((ObjectNode)json, (String)PRIVATE_ETR_RLOC_ADDRESS);
        JsonNode rtrRlocJson = json.get(RTR_RLOC_ADDRESSES);
        MappingAddress globalEtrRlocAddress = null;
        MappingAddress msRlocAddress = null;
        MappingAddress privateEtrRlocAddress = null;
        ArrayList rtrRlocAddresses = Lists.newArrayList();
        if (globalEtrRlocJson != null) {
            globalEtrRlocAddress = (MappingAddress)addressCodec.decode(globalEtrRlocJson, context);
        }
        if (msRlocJson != null) {
            msRlocAddress = (MappingAddress)addressCodec.decode(msRlocJson, context);
        }
        if (privateEtrRlocJson != null) {
            privateEtrRlocAddress = (MappingAddress)addressCodec.decode(privateEtrRlocJson, context);
        }
        if (rtrRlocJson != null) {
            IntStream.range(0, rtrRlocJson.size()).forEach(i -> rtrRlocAddresses.add(addressCodec.decode(LispNatAddressCodec.get((JsonNode)rtrRlocJson, (int)i), context)));
        }
        return new LispNatAddress.Builder().withMsUdpPortNumber(msUdpPortNumber).withEtrUdpPortNumber(etrUdpPortNumber).withGlobalEtrRlocAddress(globalEtrRlocAddress).withMsRlocAddress(msRlocAddress).withPrivateEtrRlocAddress(privateEtrRlocAddress).withRtrRlocAddresses(rtrRlocAddresses).build();
    }
}

