/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.drivers.lisp.extensions.LispMulticastAddress;
import org.onosproject.mapping.addresses.MappingAddress;

public final class LispMulticastAddressCodec
extends JsonCodec<LispMulticastAddress> {
    protected static final String INSTANCE_ID = "instanceId";
    protected static final String SRC_MASK_LENGTH = "srcMaskLength";
    protected static final String GRP_MASK_LENGTH = "grpMaskLength";
    protected static final String SRC_ADDRESS = "srcAddress";
    protected static final String GRP_ADDRESS = "grpAddress";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in LispMulticastAddress";

    public ObjectNode encode(LispMulticastAddress address, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)address), (Object)"LispMulticastAddress cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(INSTANCE_ID, address.getInstanceId()).put(SRC_MASK_LENGTH, (short)address.getSrcMaskLength()).put(GRP_MASK_LENGTH, (short)address.getGrpMaskLength());
        JsonCodec addressCodec = context.codec(MappingAddress.class);
        if (address.getSrcAddress() != null) {
            ObjectNode srcAddressNode = addressCodec.encode((Object)address.getSrcAddress(), context);
            result.set(SRC_ADDRESS, (JsonNode)srcAddressNode);
        }
        if (address.getGrpAddress() != null) {
            ObjectNode grpAddressNode = addressCodec.encode((Object)address.getGrpAddress(), context);
            result.set(GRP_ADDRESS, (JsonNode)grpAddressNode);
        }
        return result;
    }

    public LispMulticastAddress decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        int instanceId = ((JsonNode)Tools.nullIsIllegal((Object)json.get(INSTANCE_ID), (String)"instanceId member is required in LispMulticastAddress")).asInt();
        byte srcMaskLength = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get(SRC_MASK_LENGTH), (String)"srcMaskLength member is required in LispMulticastAddress")).asInt();
        byte grpMaskLength = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get(GRP_MASK_LENGTH), (String)"grpMaskLength member is required in LispMulticastAddress")).asInt();
        JsonCodec addressCodec = context.codec(MappingAddress.class);
        ObjectNode srcAddressJson = LispMulticastAddressCodec.get((ObjectNode)json, (String)SRC_ADDRESS);
        MappingAddress srcAddress = null;
        if (srcAddressJson != null) {
            srcAddress = (MappingAddress)addressCodec.decode(srcAddressJson, context);
        }
        ObjectNode grpAddressJson = LispMulticastAddressCodec.get((ObjectNode)json, (String)GRP_ADDRESS);
        MappingAddress grpAddress = null;
        if (grpAddressJson != null) {
            grpAddress = (MappingAddress)addressCodec.decode(grpAddressJson, context);
        }
        return new LispMulticastAddress.Builder().withInstanceId(instanceId).withSrcMaskLength(srcMaskLength).withGrpMaskLength(grpMaskLength).withSrcAddress(srcAddress).withGrpAddress(grpAddress).build();
    }
}

