/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.drivers.lisp.extensions.LispListAddress;
import org.onosproject.mapping.addresses.MappingAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LispListAddressCodec
extends JsonCodec<LispListAddress> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String IPV4 = "ipv4";
    protected static final String IPV6 = "ipv6";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in LispListAddress";

    public ObjectNode encode(LispListAddress address, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)address), (Object)"LispListAddress cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        JsonCodec addressCodec = context.codec(MappingAddress.class);
        if (address.getIpv4() != null) {
            ObjectNode ipv4Node = addressCodec.encode((Object)address.getIpv4(), context);
            result.set(IPV4, (JsonNode)ipv4Node);
        }
        if (address.getIpv6() != null) {
            ObjectNode ipv6Node = addressCodec.encode((Object)address.getIpv6(), context);
            result.set(IPV6, (JsonNode)ipv6Node);
        }
        if (address.getIpv4() == null && address.getIpv6() == null) {
            this.log.error("Either IPv4 or IPv6 address should be specified.");
        }
        return result;
    }

    public LispListAddress decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        JsonCodec addressCodec = context.codec(MappingAddress.class);
        ObjectNode ipv4Json = LispListAddressCodec.get((ObjectNode)json, (String)IPV4);
        ObjectNode ipv6Json = LispListAddressCodec.get((ObjectNode)json, (String)IPV6);
        MappingAddress ipv4Address = null;
        MappingAddress ipv6Address = null;
        if (ipv4Json != null) {
            ipv4Address = (MappingAddress)addressCodec.decode(ipv4Json, context);
        }
        if (ipv6Json != null) {
            ipv6Address = (MappingAddress)addressCodec.decode(ipv6Json, context);
        }
        if (ipv4Json == null && ipv6Json == null) {
            this.log.error("Either IPv4 or IPv6 address should be specified.");
        }
        return new LispListAddress.Builder().withIpv4(ipv4Address).withIpv6(ipv6Address).build();
    }
}

