/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.drivers.lisp.extensions.LispGcAddress;
import org.onosproject.mapping.addresses.MappingAddress;

public final class LispGcAddressCodec
extends JsonCodec<LispGcAddress> {
    protected static final String NORTH = "north";
    protected static final String LATITUDE_DEGREE = "latitudeDegree";
    protected static final String LATITUDE_MINUTE = "latitudeMinute";
    protected static final String LATITUDE_SECOND = "latitudeSecond";
    protected static final String EAST = "east";
    protected static final String LONGITUDE_DEGREE = "longitudeDegree";
    protected static final String LONGITUDE_MINUTE = "longitudeMinute";
    protected static final String LONGITUDE_SECOND = "longitudeSecond";
    protected static final String ALTITUDE = "altitude";
    protected static final String ADDRESS = "address";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in LispGcAddress";

    public ObjectNode encode(LispGcAddress address, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)address), (Object)"LispGcAddress cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(NORTH, address.isNorth()).put(LATITUDE_DEGREE, address.getLatitudeDegree()).put(LATITUDE_MINUTE, (short)address.getLatitudeMinute()).put(LATITUDE_SECOND, (short)address.getLatitudeSecond()).put(EAST, address.isEast()).put(LONGITUDE_DEGREE, address.getLongitudeDegree()).put(LONGITUDE_MINUTE, (short)address.getLongitudeMinute()).put(LONGITUDE_SECOND, (short)address.getLongitudeSecond()).put(ALTITUDE, address.getAltitude());
        if (address.getAddress() != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            ObjectNode addressNode = addressCodec.encode((Object)address.getAddress(), context);
            result.set(ADDRESS, (JsonNode)addressNode);
        }
        return result;
    }

    public LispGcAddress decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        boolean north = ((JsonNode)Tools.nullIsIllegal((Object)json.get(NORTH), (String)"north member is required in LispGcAddress")).asBoolean();
        short latitudeDegree = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get(LATITUDE_DEGREE), (String)"latitudeDegree member is required in LispGcAddress")).asInt();
        byte latitudeMinute = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get(LATITUDE_MINUTE), (String)"latitudeMinute member is required in LispGcAddress")).asInt();
        byte latitudeSecond = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get(LATITUDE_SECOND), (String)"latitudeSecond member is required in LispGcAddress")).asInt();
        boolean east = ((JsonNode)Tools.nullIsIllegal((Object)json.get(EAST), (String)"east member is required in LispGcAddress")).asBoolean();
        short longitudeDegree = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get(LONGITUDE_DEGREE), (String)"longitudeDegree member is required in LispGcAddress")).asInt();
        byte longitudeMinute = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get(LONGITUDE_MINUTE), (String)"longitudeMinute member is required in LispGcAddress")).asInt();
        byte longitudeSecond = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get(LONGITUDE_SECOND), (String)"longitudeSecond member is required in LispGcAddress")).asInt();
        int altitude = ((JsonNode)Tools.nullIsIllegal((Object)json.get(ALTITUDE), (String)"altitude member is required in LispGcAddress")).asInt();
        ObjectNode addressJson = LispGcAddressCodec.get((ObjectNode)json, (String)ADDRESS);
        MappingAddress mappingAddress = null;
        if (addressJson != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            mappingAddress = (MappingAddress)addressCodec.decode(addressJson, context);
        }
        return new LispGcAddress.Builder().withIsNorth(north).withLatitudeDegree(latitudeDegree).withLatitudeMinute(latitudeMinute).withLatitudeSecond(latitudeSecond).withIsEast(east).withLongitudeDegree(longitudeDegree).withLongitudeMinute(longitudeMinute).withLongitudeSecond(longitudeSecond).withAltitude(altitude).withAddress(mappingAddress).build();
    }
}

