/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.drivers.lisp.extensions.LispAsAddress;
import org.onosproject.mapping.addresses.MappingAddress;

public final class LispAsAddressCodec
extends JsonCodec<LispAsAddress> {
    protected static final String AS_NUMBER = "asNumber";
    protected static final String ADDRESS = "address";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in LispAsAddress";

    public ObjectNode encode(LispAsAddress address, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)address), (Object)"LispAsAddress cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(AS_NUMBER, address.getAsNumber());
        if (address.getAddress() != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            ObjectNode addressNode = addressCodec.encode((Object)address.getAddress(), context);
            result.set(ADDRESS, (JsonNode)addressNode);
        }
        return result;
    }

    public LispAsAddress decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        int asNumber = ((JsonNode)Tools.nullIsIllegal((Object)json.get(AS_NUMBER), (String)"asNumber member is required in LispAsAddress")).asInt();
        ObjectNode addressJson = LispAsAddressCodec.get((ObjectNode)json, (String)ADDRESS);
        MappingAddress mappingAddress = null;
        if (addressJson != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            mappingAddress = (MappingAddress)addressCodec.decode(addressJson, context);
        }
        return new LispAsAddress.Builder().withAsNumber(asNumber).withAddress(mappingAddress).build();
    }
}

