/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.drivers.lisp.extensions.LispAppDataAddress;
import org.onosproject.mapping.addresses.MappingAddress;

public final class LispAppDataAddressCodec
extends JsonCodec<LispAppDataAddress> {
    protected static final String PROTOCOL = "protocol";
    protected static final String IP_TOS = "ipTos";
    protected static final String LOCAL_PORT_LOW = "localPortLow";
    protected static final String LOCAL_PORT_HIGH = "localPortHigh";
    protected static final String REMOTE_PORT_LOW = "remotePortLow";
    protected static final String REMOTE_PORT_HIGH = "remotePortHigh";
    protected static final String ADDRESS = "address";

    public ObjectNode encode(LispAppDataAddress address, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)address), (Object)"LispAppDataAddress cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(PROTOCOL, (short)address.getProtocol()).put(IP_TOS, address.getIpTos()).put(LOCAL_PORT_LOW, address.getLocalPortLow()).put(LOCAL_PORT_HIGH, address.getLocalPortHigh()).put(REMOTE_PORT_LOW, address.getRemotePortLow()).put(REMOTE_PORT_HIGH, address.getRemotePortHigh());
        if (address.getAddress() != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            ObjectNode addressNode = addressCodec.encode((Object)address.getAddress(), context);
            result.set(ADDRESS, (JsonNode)addressNode);
        }
        return result;
    }

    public LispAppDataAddress decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        byte protocol = (byte)json.get(PROTOCOL).asInt();
        int ipTos = json.get(IP_TOS).asInt();
        short localPortLow = (short)json.get(LOCAL_PORT_LOW).asInt();
        short localPortHigh = (short)json.get(LOCAL_PORT_HIGH).asInt();
        short remotePortLow = (short)json.get(REMOTE_PORT_LOW).asInt();
        short remotePortHigh = (short)json.get(REMOTE_PORT_HIGH).asInt();
        ObjectNode addressJson = LispAppDataAddressCodec.get((ObjectNode)json, (String)ADDRESS);
        MappingAddress mappingAddress = null;
        if (addressJson != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            mappingAddress = (MappingAddress)addressCodec.decode(addressJson, context);
        }
        return new LispAppDataAddress.Builder().withProtocol(protocol).withIpTos(ipTos).withLocalPortLow(localPortLow).withLocalPortHigh(localPortHigh).withRemotePortLow(remotePortLow).withRemotePortHigh(remotePortHigh).withAddress(mappingAddress).build();
    }
}

