/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.onlab.util.KryoNamespace;
import org.onosproject.mapping.addresses.ASMappingAddress;
import org.onosproject.mapping.addresses.DNMappingAddress;
import org.onosproject.mapping.addresses.EthMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.IPMappingAddress;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.flow.AbstractExtension;
import org.onosproject.store.serializers.KryoNamespaces;

public final class LispTeAddress
extends AbstractExtension
implements ExtensionMappingAddress {
    private static final String TE_RECORDS = "records";
    private List<TeRecord> records;
    private KryoNamespace appKryo = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{MappingAddress.class}).register(new Class[]{MappingAddress.Type.class}).register(new Class[]{IPMappingAddress.class}).register(new Class[]{ASMappingAddress.class}).register(new Class[]{DNMappingAddress.class}).register(new Class[]{EthMappingAddress.class}).register(new Class[]{TeRecord.class}).build();

    public LispTeAddress() {
    }

    private LispTeAddress(List<TeRecord> records) {
        this.records = records;
    }

    public List<TeRecord> getTeRecords() {
        return ImmutableList.copyOf(this.records);
    }

    public ExtensionMappingAddressType type() {
        return ExtensionMappingAddressType.ExtensionMappingAddressTypes.TRAFFIC_ENGINEERING_ADDRESS.type();
    }

    public byte[] serialize() {
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put(TE_RECORDS, this.records);
        return this.appKryo.serialize((Object)parameterMap);
    }

    public void deserialize(byte[] data) {
        Map parameterMap = (Map)this.appKryo.deserialize(data);
        this.records = (List)parameterMap.get(TE_RECORDS);
    }

    public int hashCode() {
        return Objects.hash(this.records);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispTeAddress) {
            LispTeAddress other = (LispTeAddress)((Object)obj);
            return Objects.equals(this.records, other.records);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add("TE records", this.records).toString();
    }

    public static final class TeRecord {
        private boolean lookup;
        private boolean rlocProbe;
        private boolean strict;
        private MappingAddress address;

        private TeRecord(boolean lookup, boolean rlocProbe, boolean strict, MappingAddress address) {
            this.lookup = lookup;
            this.rlocProbe = rlocProbe;
            this.strict = strict;
            this.address = address;
        }

        public boolean isLookup() {
            return this.lookup;
        }

        public boolean isRlocProbe() {
            return this.rlocProbe;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public MappingAddress getAddress() {
            return this.address;
        }

        public int hashCode() {
            return Objects.hash(this.lookup, this.rlocProbe, this.strict, this.address);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TeRecord) {
                TeRecord other = (TeRecord)obj;
                return Objects.equals(this.lookup, other.lookup) && Objects.equals(this.rlocProbe, other.rlocProbe) && Objects.equals(this.strict, other.strict) && Objects.equals(this.address, other.address);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("Lookup bit", this.lookup).add("RLOC probe bit", this.rlocProbe).add("strict bit", this.strict).add("RTR address", (Object)this.address).toString();
        }

        public static final class Builder {
            private boolean lookup;
            private boolean rlocProbe;
            private boolean strict;
            private MappingAddress address;

            public Builder withIsLookup(boolean lookup) {
                this.lookup = lookup;
                return this;
            }

            public Builder withIsRlocProbe(boolean rlocProbe) {
                this.rlocProbe = rlocProbe;
                return this;
            }

            public Builder withIsStrict(boolean strict) {
                this.strict = strict;
                return this;
            }

            public Builder withRtrRlocAddress(MappingAddress address) {
                this.address = address;
                return this;
            }

            public TeRecord build() {
                return new TeRecord(this.lookup, this.rlocProbe, this.strict, this.address);
            }
        }
    }

    public static final class Builder {
        private List<TeRecord> records;

        public Builder withTeRecords(List<TeRecord> records) {
            this.records = records;
            return this;
        }

        public LispTeAddress build() {
            return new LispTeAddress(this.records);
        }
    }
}

