/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.flow.AbstractExtension;

public class LispSrcDstAddress
extends AbstractExtension
implements ExtensionMappingAddress {
    private static final String SRC_MASK_LENGTH = "srcMaskLength";
    private static final String DST_MASK_LENGTH = "dstMaskLength";
    private static final String SRC_PREFIX = "srcPrefix";
    private static final String DST_PREFIX = "dstPrefix";
    private byte srcMaskLength;
    private byte dstMaskLength;
    private MappingAddress srcPrefix;
    private MappingAddress dstPrefix;

    public LispSrcDstAddress() {
    }

    private LispSrcDstAddress(byte srcMaskLength, byte dstMaskLength, MappingAddress srcPrefix, MappingAddress dstPrefix) {
        this.srcMaskLength = srcMaskLength;
        this.dstMaskLength = dstMaskLength;
        this.srcPrefix = srcPrefix;
        this.dstPrefix = dstPrefix;
    }

    public byte getSrcMaskLength() {
        return this.srcMaskLength;
    }

    public byte getDstMaskLength() {
        return this.dstMaskLength;
    }

    public MappingAddress getSrcPrefix() {
        return this.srcPrefix;
    }

    public MappingAddress getDstPrefix() {
        return this.dstPrefix;
    }

    public ExtensionMappingAddressType type() {
        return ExtensionMappingAddressType.ExtensionMappingAddressTypes.SOURCE_DEST_ADDRESS.type();
    }

    public byte[] serialize() {
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put(SRC_MASK_LENGTH, this.srcMaskLength);
        parameterMap.put(DST_MASK_LENGTH, this.dstMaskLength);
        parameterMap.put(SRC_PREFIX, this.srcPrefix);
        parameterMap.put(DST_PREFIX, this.dstPrefix);
        return APP_KRYO.serialize((Object)parameterMap);
    }

    public void deserialize(byte[] data) {
        Map parameterMap = (Map)APP_KRYO.deserialize(data);
        this.srcMaskLength = (Byte)parameterMap.get(SRC_MASK_LENGTH);
        this.dstMaskLength = (Byte)parameterMap.get(DST_MASK_LENGTH);
        this.srcPrefix = (MappingAddress)parameterMap.get(SRC_PREFIX);
        this.dstPrefix = (MappingAddress)parameterMap.get(DST_PREFIX);
    }

    public int hashCode() {
        return Objects.hash(this.srcPrefix, this.dstPrefix, this.srcMaskLength, this.dstMaskLength);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispSrcDstAddress) {
            LispSrcDstAddress other = (LispSrcDstAddress)((Object)obj);
            return Objects.equals(this.srcPrefix, other.srcPrefix) && Objects.equals(this.dstPrefix, other.dstPrefix) && Objects.equals(this.srcMaskLength, other.srcMaskLength) && Objects.equals(this.dstMaskLength, other.dstMaskLength);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add("source prefix", (Object)this.srcPrefix).add("destination prefix", (Object)this.dstPrefix).add("source mask length", (int)this.srcMaskLength).add("destination mask length", (int)this.dstMaskLength).toString();
    }

    public static final class Builder {
        private byte srcMaskLength;
        private byte dstMaskLength;
        private MappingAddress srcPrefix;
        private MappingAddress dstPrefix;

        public Builder withSrcPrefix(MappingAddress srcPrefix) {
            this.srcPrefix = srcPrefix;
            return this;
        }

        public Builder withDstPrefix(MappingAddress dstPrefix) {
            this.dstPrefix = dstPrefix;
            return this;
        }

        public Builder withSrcMaskLength(byte srcMaskLength) {
            this.srcMaskLength = srcMaskLength;
            return this;
        }

        public Builder withDstMaskLength(byte dstMaskLength) {
            this.dstMaskLength = dstMaskLength;
            return this;
        }

        public LispSrcDstAddress build() {
            return new LispSrcDstAddress(this.srcMaskLength, this.dstMaskLength, this.srcPrefix, this.dstPrefix);
        }
    }
}

