/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.flow.AbstractExtension;

public class LispSegmentAddress
extends AbstractExtension
implements ExtensionMappingAddress {
    private static final String INSTANCE_ID = "instanceId";
    private static final String ADDRESS = "address";
    private int instanceId;
    private MappingAddress address;

    public LispSegmentAddress() {
    }

    private LispSegmentAddress(int instanceId, MappingAddress address) {
        this.instanceId = instanceId;
        this.address = address;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public MappingAddress getAddress() {
        return this.address;
    }

    public ExtensionMappingAddressType type() {
        return ExtensionMappingAddressType.ExtensionMappingAddressTypes.SEGMENT_ADDRESS.type();
    }

    public byte[] serialize() {
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put(INSTANCE_ID, this.instanceId);
        parameterMap.put(ADDRESS, this.address);
        return APP_KRYO.serialize((Object)parameterMap);
    }

    public void deserialize(byte[] data) {
        Map parameterMap = (Map)APP_KRYO.deserialize(data);
        this.instanceId = (Integer)parameterMap.get(INSTANCE_ID);
        this.address = (MappingAddress)parameterMap.get(ADDRESS);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.instanceId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispSegmentAddress) {
            LispSegmentAddress other = (LispSegmentAddress)((Object)obj);
            return Objects.equals(this.address, other.address) && Objects.equals(this.instanceId, other.instanceId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add(ADDRESS, (Object)this.address).add(INSTANCE_ID, this.instanceId).toString();
    }

    public static final class Builder {
        private int instanceId;
        private MappingAddress address;

        public Builder withInstanceId(int instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withAddress(MappingAddress address) {
            this.address = address;
            return this;
        }

        public LispSegmentAddress build() {
            return new LispSegmentAddress(this.instanceId, this.address);
        }
    }
}

