/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.flow.AbstractExtension;

public class LispNonceAddress
extends AbstractExtension
implements ExtensionMappingAddress {
    private static final String NONCE = "nonce";
    private static final String ADDRESS = "address";
    private int nonce;
    private MappingAddress address;

    public LispNonceAddress() {
    }

    private LispNonceAddress(int nonce, MappingAddress address) {
        this.nonce = nonce;
        this.address = address;
    }

    public int getNonce() {
        return this.nonce;
    }

    public MappingAddress getAddress() {
        return this.address;
    }

    public ExtensionMappingAddressType type() {
        return ExtensionMappingAddressType.ExtensionMappingAddressTypes.NONCE_ADDRESS.type();
    }

    public byte[] serialize() {
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put(NONCE, this.nonce);
        parameterMap.put(ADDRESS, this.address);
        return APP_KRYO.serialize((Object)parameterMap);
    }

    public void deserialize(byte[] data) {
        Map parameterMap = (Map)APP_KRYO.deserialize(data);
        this.nonce = (Integer)parameterMap.get(NONCE);
        this.address = (MappingAddress)parameterMap.get(ADDRESS);
    }

    public int hashCode() {
        return Objects.hash(this.nonce, this.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispNonceAddress) {
            LispNonceAddress other = (LispNonceAddress)((Object)obj);
            return Objects.equals(this.nonce, other.nonce) && Objects.equals(this.address, other.address);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add(NONCE, this.nonce).add(ADDRESS, (Object)this.address).toString();
    }

    public static final class Builder {
        private int nonce;
        private MappingAddress address;

        public Builder withNonce(int nonce) {
            this.nonce = nonce;
            return this;
        }

        public Builder withAddress(MappingAddress address) {
            this.address = address;
            return this;
        }

        public LispNonceAddress build() {
            return new LispNonceAddress(this.nonce, this.address);
        }
    }
}

