/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.flow.AbstractExtension;

public class LispNatAddress
extends AbstractExtension
implements ExtensionMappingAddress {
    private static final String MS_UDP_PORT_NUMBER = "msUdpPortNumber";
    private static final String ETR_UDP_PORT_NUMBER = "etrUdpPortNumber";
    private static final String GLOBAL_ETR_RLOC_ADDRESS = "globalEtrRlocAddress";
    private static final String MS_RLOC_ADDRESS = "msRlocAddress";
    private static final String PRIVATE_ETR_RLOC_ADDRESS = "privateEtrRlocAddress";
    private static final String RTR_RLOC_ADDRESSES = "rtrRlocAddresses";
    private short msUdpPortNumber;
    private short etrUdpPortNumber;
    private MappingAddress globalEtrRlocAddress;
    private MappingAddress msRlocAddress;
    private MappingAddress privateEtrRlocAddress;
    private List<MappingAddress> rtrRlocAddresses;

    public LispNatAddress() {
    }

    private LispNatAddress(short msUdpPortNumber, short etrUdpPortNumber, MappingAddress globalEtrRlocAddress, MappingAddress msRlocAddress, MappingAddress privateEtrRlocAddress, List<MappingAddress> rtrRlocAddresses) {
        this.msUdpPortNumber = msUdpPortNumber;
        this.etrUdpPortNumber = etrUdpPortNumber;
        this.globalEtrRlocAddress = globalEtrRlocAddress;
        this.msRlocAddress = msRlocAddress;
        this.privateEtrRlocAddress = privateEtrRlocAddress;
        this.rtrRlocAddresses = ImmutableList.copyOf(rtrRlocAddresses);
    }

    public short getMsUdpPortNumber() {
        return this.msUdpPortNumber;
    }

    public short getEtrUdpPortNumber() {
        return this.etrUdpPortNumber;
    }

    public MappingAddress getGlobalEtrRlocAddress() {
        return this.globalEtrRlocAddress;
    }

    public MappingAddress getMsRlocAddress() {
        return this.msRlocAddress;
    }

    public MappingAddress getPrivateEtrRlocAddress() {
        return this.privateEtrRlocAddress;
    }

    public List<MappingAddress> getRtrRlocAddresses() {
        return ImmutableList.copyOf(this.rtrRlocAddresses);
    }

    public ExtensionMappingAddressType type() {
        return ExtensionMappingAddressType.ExtensionMappingAddressTypes.NAT_ADDRESS.type();
    }

    public byte[] serialize() {
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put(MS_UDP_PORT_NUMBER, this.msUdpPortNumber);
        parameterMap.put(ETR_UDP_PORT_NUMBER, this.etrUdpPortNumber);
        parameterMap.put(GLOBAL_ETR_RLOC_ADDRESS, this.globalEtrRlocAddress);
        parameterMap.put(MS_RLOC_ADDRESS, this.msRlocAddress);
        parameterMap.put(PRIVATE_ETR_RLOC_ADDRESS, this.privateEtrRlocAddress);
        parameterMap.put(RTR_RLOC_ADDRESSES, this.rtrRlocAddresses);
        return APP_KRYO.serialize((Object)parameterMap);
    }

    public void deserialize(byte[] data) {
        Map parameterMap = (Map)APP_KRYO.deserialize(data);
        this.msUdpPortNumber = (Short)parameterMap.get(MS_UDP_PORT_NUMBER);
        this.etrUdpPortNumber = (Short)parameterMap.get(ETR_UDP_PORT_NUMBER);
        this.globalEtrRlocAddress = (MappingAddress)parameterMap.get(GLOBAL_ETR_RLOC_ADDRESS);
        this.msRlocAddress = (MappingAddress)parameterMap.get(MS_RLOC_ADDRESS);
        this.privateEtrRlocAddress = (MappingAddress)parameterMap.get(PRIVATE_ETR_RLOC_ADDRESS);
        this.rtrRlocAddresses = (List)parameterMap.get(RTR_RLOC_ADDRESSES);
    }

    public int hashCode() {
        return Objects.hash(this.msUdpPortNumber, this.etrUdpPortNumber, this.globalEtrRlocAddress, this.msRlocAddress, this.privateEtrRlocAddress);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispNatAddress) {
            LispNatAddress other = (LispNatAddress)((Object)obj);
            return Objects.equals(this.msUdpPortNumber, other.msUdpPortNumber) && Objects.equals(this.etrUdpPortNumber, other.etrUdpPortNumber) && Objects.equals(this.globalEtrRlocAddress, other.globalEtrRlocAddress) && Objects.equals(this.msRlocAddress, other.msRlocAddress) && Objects.equals(this.privateEtrRlocAddress, other.privateEtrRlocAddress) && Objects.equals(this.rtrRlocAddresses, other.rtrRlocAddresses);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add("Map Server UDP port number", (int)this.msUdpPortNumber).add("ETR UDP port number", (int)this.etrUdpPortNumber).add("global ETR RLOC address", (Object)this.globalEtrRlocAddress).add("Map Server RLOC address", (Object)this.msRlocAddress).add("private ETR RLOC address", (Object)this.privateEtrRlocAddress).add("RTR RLOC addresses", this.rtrRlocAddresses).toString();
    }

    public static final class Builder {
        private short msUdpPortNumber;
        private short etrUdpPortNumber;
        private MappingAddress globalEtrRlocAddress;
        private MappingAddress msRlocAddress;
        private MappingAddress privateEtrRlocAddress;
        private List<MappingAddress> rtrRlocAddresses;

        public Builder withMsUdpPortNumber(short msUdpPortNumber) {
            this.msUdpPortNumber = msUdpPortNumber;
            return this;
        }

        public Builder withEtrUdpPortNumber(short etrUdpPortNumber) {
            this.etrUdpPortNumber = etrUdpPortNumber;
            return this;
        }

        public Builder withGlobalEtrRlocAddress(MappingAddress globalEtrRlocAddress) {
            this.globalEtrRlocAddress = globalEtrRlocAddress;
            return this;
        }

        public Builder withMsRlocAddress(MappingAddress msRlocAddress) {
            this.msRlocAddress = msRlocAddress;
            return this;
        }

        public Builder withPrivateEtrRlocAddress(MappingAddress privateEtrRlocAddress) {
            this.privateEtrRlocAddress = privateEtrRlocAddress;
            return this;
        }

        public Builder withRtrRlocAddresses(List<MappingAddress> rtrRlocAddresses) {
            if (rtrRlocAddresses != null) {
                this.rtrRlocAddresses = ImmutableList.copyOf(rtrRlocAddresses);
            }
            return this;
        }

        public LispNatAddress build() {
            return new LispNatAddress(this.msUdpPortNumber, this.etrUdpPortNumber, this.globalEtrRlocAddress, this.msRlocAddress, this.privateEtrRlocAddress, this.rtrRlocAddresses);
        }
    }
}

