/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.flow.AbstractExtension;

public class LispMulticastAddress
extends AbstractExtension
implements ExtensionMappingAddress {
    private static final String INSTANCE_ID = "instanceId";
    private static final String SRC_MASK_LENGTH = "srcMaskLength";
    private static final String GRP_MASK_LENGTH = "grpMaskLength";
    private static final String SRC_ADDRESS = "srcAddress";
    private static final String GRP_ADDRESS = "grpAddress";
    private int instanceId;
    private byte srcMaskLength;
    private byte grpMaskLength;
    private MappingAddress srcAddress;
    private MappingAddress grpAddress;

    public LispMulticastAddress() {
    }

    private LispMulticastAddress(int instanceId, byte srcMaskLength, byte grpMaskLength, MappingAddress srcAddress, MappingAddress grpAddress) {
        this.instanceId = instanceId;
        this.srcMaskLength = srcMaskLength;
        this.grpMaskLength = grpMaskLength;
        this.srcAddress = srcAddress;
        this.grpAddress = grpAddress;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public byte getSrcMaskLength() {
        return this.srcMaskLength;
    }

    public byte getGrpMaskLength() {
        return this.grpMaskLength;
    }

    public MappingAddress getSrcAddress() {
        return this.srcAddress;
    }

    public MappingAddress getGrpAddress() {
        return this.grpAddress;
    }

    public ExtensionMappingAddressType type() {
        return ExtensionMappingAddressType.ExtensionMappingAddressTypes.MULTICAST_ADDRESS.type();
    }

    public byte[] serialize() {
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put(INSTANCE_ID, this.instanceId);
        parameterMap.put(SRC_MASK_LENGTH, this.srcMaskLength);
        parameterMap.put(GRP_MASK_LENGTH, this.grpMaskLength);
        parameterMap.put(SRC_ADDRESS, this.srcAddress);
        parameterMap.put(GRP_ADDRESS, this.grpAddress);
        return APP_KRYO.serialize((Object)parameterMap);
    }

    public void deserialize(byte[] data) {
        Map parameterMap = (Map)APP_KRYO.deserialize(data);
        this.instanceId = (Integer)parameterMap.get(INSTANCE_ID);
        this.srcMaskLength = (Byte)parameterMap.get(SRC_MASK_LENGTH);
        this.grpMaskLength = (Byte)parameterMap.get(GRP_MASK_LENGTH);
        this.srcAddress = (MappingAddress)parameterMap.get(SRC_ADDRESS);
        this.grpAddress = (MappingAddress)parameterMap.get(GRP_ADDRESS);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.srcMaskLength, this.grpMaskLength, this.srcAddress, this.grpAddress);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispMulticastAddress) {
            LispMulticastAddress other = (LispMulticastAddress)((Object)obj);
            return Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.srcMaskLength, other.srcMaskLength) && Objects.equals(this.grpMaskLength, other.grpMaskLength) && Objects.equals(this.srcAddress, other.srcAddress) && Objects.equals(this.grpAddress, other.grpAddress);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add("instance ID", this.instanceId).add("source mask length", (int)this.srcMaskLength).add("group mask length", (int)this.grpMaskLength).add("source address", (Object)this.srcAddress).add("group address", (Object)this.grpAddress).toString();
    }

    public static final class Builder {
        private int instanceId;
        private byte srcMaskLength;
        private byte grpMaskLength;
        private MappingAddress srcAddress;
        private MappingAddress grpAddress;

        public Builder withInstanceId(int instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withSrcMaskLength(byte srcMaskLength) {
            this.srcMaskLength = srcMaskLength;
            return this;
        }

        public Builder withGrpMaskLength(byte grpMaskLength) {
            this.grpMaskLength = grpMaskLength;
            return this;
        }

        public Builder withSrcAddress(MappingAddress srcAddress) {
            this.srcAddress = srcAddress;
            return this;
        }

        public Builder withGrpAddress(MappingAddress grpAddress) {
            this.grpAddress = grpAddress;
            return this;
        }

        public LispMulticastAddress build() {
            return new LispMulticastAddress(this.instanceId, this.srcMaskLength, this.grpMaskLength, this.srcAddress, this.grpAddress);
        }
    }
}

