/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.flow.AbstractExtension;

public class LispListAddress
extends AbstractExtension
implements ExtensionMappingAddress {
    private static final String IPV4 = "ipv4";
    private static final String IPV6 = "ipv6";
    private MappingAddress ipv4;
    private MappingAddress ipv6;

    public LispListAddress() {
    }

    private LispListAddress(MappingAddress ipv4, MappingAddress ipv6) {
        this.ipv4 = ipv4;
        this.ipv6 = ipv6;
    }

    public MappingAddress getIpv4() {
        return this.ipv4;
    }

    public MappingAddress getIpv6() {
        return this.ipv6;
    }

    public ExtensionMappingAddressType type() {
        return ExtensionMappingAddressType.ExtensionMappingAddressTypes.LIST_ADDRESS.type();
    }

    public byte[] serialize() {
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put(IPV4, this.ipv4);
        parameterMap.put(IPV6, this.ipv6);
        return APP_KRYO.serialize((Object)parameterMap);
    }

    public void deserialize(byte[] data) {
        Map parameterMap = (Map)APP_KRYO.deserialize(data);
        this.ipv4 = (MappingAddress)parameterMap.get(IPV4);
        this.ipv6 = (MappingAddress)parameterMap.get(IPV6);
    }

    public int hashCode() {
        return Objects.hash(this.ipv4, this.ipv6);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispListAddress) {
            LispListAddress that = (LispListAddress)((Object)obj);
            return Objects.equals(this.ipv4, that.ipv4) && Objects.equals(this.ipv6, that.ipv6);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add(IPV4, (Object)this.ipv4).add(IPV6, (Object)this.ipv6).toString();
    }

    public static final class Builder {
        private MappingAddress ipv4;
        private MappingAddress ipv6;

        public Builder withIpv4(MappingAddress ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        public Builder withIpv6(MappingAddress ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        public LispListAddress build() {
            return new LispListAddress(this.ipv4, this.ipv6);
        }
    }
}

