/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.flow.AbstractExtension;

public class LispGcAddress
extends AbstractExtension
implements ExtensionMappingAddress {
    private static final String NORTH = "north";
    private static final String LATITUDE_DEGREE = "latitudeDegree";
    private static final String LATITUDE_MINUTE = "latitudeMinute";
    private static final String LATITUDE_SECOND = "latitudeSecond";
    private static final String EAST = "east";
    private static final String LONGITUDE_DEGREE = "longitudeDegree";
    private static final String LONGITUDE_MINUTE = "longitudeMinute";
    private static final String LONGITUDE_SECOND = "longitudeSecond";
    private static final String ALTITUDE = "altitude";
    private static final String ADDRESS = "address";
    private boolean north;
    private short latitudeDegree;
    private byte latitudeMinute;
    private byte latitudeSecond;
    private boolean east;
    private short longitudeDegree;
    private byte longitudeMinute;
    private byte longitudeSecond;
    private int altitude;
    private MappingAddress address;

    public LispGcAddress() {
    }

    private LispGcAddress(boolean north, short latitudeDegree, byte latitudeMinute, byte latitudeSecond, boolean east, short longitudeDegree, byte longitudeMinute, byte longitudeSecond, int altitude, MappingAddress address) {
        this.north = north;
        this.latitudeDegree = latitudeDegree;
        this.latitudeMinute = latitudeMinute;
        this.latitudeSecond = latitudeSecond;
        this.east = east;
        this.longitudeDegree = longitudeDegree;
        this.longitudeMinute = longitudeMinute;
        this.longitudeSecond = longitudeSecond;
        this.altitude = altitude;
        this.address = address;
    }

    public boolean isNorth() {
        return this.north;
    }

    public short getLatitudeDegree() {
        return this.latitudeDegree;
    }

    public byte getLatitudeMinute() {
        return this.latitudeMinute;
    }

    public byte getLatitudeSecond() {
        return this.latitudeSecond;
    }

    public boolean isEast() {
        return this.east;
    }

    public short getLongitudeDegree() {
        return this.longitudeDegree;
    }

    public byte getLongitudeMinute() {
        return this.longitudeMinute;
    }

    public byte getLongitudeSecond() {
        return this.longitudeSecond;
    }

    public int getAltitude() {
        return this.altitude;
    }

    public MappingAddress getAddress() {
        return this.address;
    }

    public ExtensionMappingAddressType type() {
        return ExtensionMappingAddressType.ExtensionMappingAddressTypes.GEO_COORDINATE_ADDRESS.type();
    }

    public byte[] serialize() {
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put(NORTH, this.north);
        parameterMap.put(LATITUDE_DEGREE, this.latitudeDegree);
        parameterMap.put(LATITUDE_MINUTE, this.latitudeMinute);
        parameterMap.put(LATITUDE_SECOND, this.latitudeSecond);
        parameterMap.put(EAST, this.east);
        parameterMap.put(LONGITUDE_DEGREE, this.longitudeDegree);
        parameterMap.put(LONGITUDE_MINUTE, this.longitudeMinute);
        parameterMap.put(LONGITUDE_SECOND, this.longitudeSecond);
        parameterMap.put(ALTITUDE, this.altitude);
        parameterMap.put(ADDRESS, this.address);
        return APP_KRYO.serialize((Object)parameterMap);
    }

    public void deserialize(byte[] data) {
        Map parameterMap = (Map)APP_KRYO.deserialize(data);
        this.north = (Boolean)parameterMap.get(NORTH);
        this.latitudeDegree = (Short)parameterMap.get(LATITUDE_DEGREE);
        this.latitudeMinute = (Byte)parameterMap.get(LATITUDE_MINUTE);
        this.latitudeSecond = (Byte)parameterMap.get(LATITUDE_SECOND);
        this.east = (Boolean)parameterMap.get(EAST);
        this.longitudeDegree = (Short)parameterMap.get(LONGITUDE_DEGREE);
        this.longitudeMinute = (Byte)parameterMap.get(LONGITUDE_MINUTE);
        this.longitudeSecond = (Byte)parameterMap.get(LONGITUDE_SECOND);
        this.altitude = (Integer)parameterMap.get(ALTITUDE);
        this.address = (MappingAddress)parameterMap.get(ADDRESS);
    }

    public int hashCode() {
        return Objects.hash(this.north, this.latitudeDegree, this.latitudeMinute, this.latitudeSecond, this.east, this.longitudeDegree, this.longitudeMinute, this.longitudeSecond, this.altitude, this.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispGcAddress) {
            LispGcAddress other = (LispGcAddress)((Object)obj);
            return Objects.equals(this.north, other.north) && Objects.equals(this.latitudeDegree, other.latitudeDegree) && Objects.equals(this.latitudeMinute, other.latitudeMinute) && Objects.equals(this.latitudeSecond, other.latitudeSecond) && Objects.equals(this.east, other.east) && Objects.equals(this.longitudeDegree, other.longitudeDegree) && Objects.equals(this.longitudeMinute, other.longitudeMinute) && Objects.equals(this.longitudeSecond, other.longitudeSecond) && Objects.equals(this.altitude, other.altitude) && Objects.equals(this.address, other.address);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add(NORTH, this.north).add("latitude degree", (int)this.latitudeDegree).add("latitude minute", (int)this.latitudeMinute).add("latitude second", (int)this.latitudeSecond).add(EAST, this.east).add("longitude degree", (int)this.longitudeDegree).add("longitude minute", (int)this.longitudeMinute).add("longitude second", (int)this.longitudeSecond).add(ALTITUDE, this.altitude).add(ADDRESS, (Object)this.address).toString();
    }

    public static final class Builder {
        private boolean north;
        private short latitudeDegree;
        private byte latitudeMinute;
        private byte latitudeSecond;
        private boolean east;
        private short longitudeDegree;
        private byte longitudeMinute;
        private byte longitudeSecond;
        private int altitude;
        private MappingAddress address;

        public Builder withIsNorth(boolean north) {
            this.north = north;
            return this;
        }

        public Builder withLatitudeDegree(short latitudeDegree) {
            this.latitudeDegree = latitudeDegree;
            return this;
        }

        public Builder withLatitudeMinute(byte latitudeMinute) {
            this.latitudeMinute = latitudeMinute;
            return this;
        }

        public Builder withLatitudeSecond(byte latitudeSecond) {
            this.latitudeSecond = latitudeSecond;
            return this;
        }

        public Builder withIsEast(boolean east) {
            this.east = east;
            return this;
        }

        public Builder withLongitudeDegree(short longitudeDegree) {
            this.longitudeDegree = longitudeDegree;
            return this;
        }

        public Builder withLongitudeMinute(byte longitudeMinute) {
            this.longitudeMinute = longitudeMinute;
            return this;
        }

        public Builder withLongitudeSecond(byte longitudeSecond) {
            this.longitudeSecond = longitudeSecond;
            return this;
        }

        public Builder withAltitude(int altitude) {
            this.altitude = altitude;
            return this;
        }

        public Builder withAddress(MappingAddress address) {
            this.address = address;
            return this;
        }

        public LispGcAddress build() {
            return new LispGcAddress(this.north, this.latitudeDegree, this.latitudeMinute, this.latitudeSecond, this.east, this.longitudeDegree, this.longitudeMinute, this.longitudeSecond, this.altitude, this.address);
        }
    }
}

