/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.drivers.lisp.extensions.LispAppDataAddress;
import org.onosproject.drivers.lisp.extensions.LispAsAddress;
import org.onosproject.drivers.lisp.extensions.LispGcAddress;
import org.onosproject.drivers.lisp.extensions.LispListAddress;
import org.onosproject.drivers.lisp.extensions.LispMulticastAddress;
import org.onosproject.drivers.lisp.extensions.LispNatAddress;
import org.onosproject.drivers.lisp.extensions.LispNonceAddress;
import org.onosproject.drivers.lisp.extensions.LispSegmentAddress;
import org.onosproject.drivers.lisp.extensions.LispSrcDstAddress;
import org.onosproject.drivers.lisp.extensions.LispTeAddress;
import org.onosproject.lisp.ctl.ExtensionMappingAddressInterpreter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispDistinguishedNameAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispIpv6Address;
import org.onosproject.lisp.msg.types.LispMacAddress;
import org.onosproject.lisp.msg.types.lcaf.LispAppDataLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispAsLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispGeoCoordinateLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispListLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispMulticastLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispNatLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispNonceLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispSegmentLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispSourceDestLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispTeLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispTeRecord;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressResolver;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.IPMappingAddress;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.mapping.addresses.MappingAddresses;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LispExtensionMappingAddressInterpreter
extends AbstractHandlerBehaviour
implements ExtensionMappingAddressInterpreter,
ExtensionMappingAddressResolver {
    private static final Logger log = LoggerFactory.getLogger(LispExtensionMappingAddressInterpreter.class);
    private static final int IPV4_PREFIX_LENGTH = 32;
    private static final int IPV6_PREFIX_LENGTH = 128;
    protected static final String LISP_LIST_ADDRESS = "listAddress";
    protected static final String LISP_SEGMENT_ADDRESS = "segmentAddress";
    protected static final String LISP_AS_ADDRESS = "asAddress";
    protected static final String LISP_APPLICATION_DATA_ADDRESS = "applicationDataAddress";
    protected static final String LISP_GEO_COORDINATE_ADDRESS = "geoCoordinateAddress";
    protected static final String LISP_NAT_ADDRESS = "natAddress";
    protected static final String LISP_NONCE_ADDRESS = "nonceAddress";
    protected static final String LISP_MULTICAST_ADDRESS = "multicastAddress";
    protected static final String LISP_TRAFFIC_ENGINEERING_ADDRESS = "trafficEngineeringAddress";
    protected static final String LISP_SOURCE_DEST_ADDRESS = "sourceDestAddress";
    private static final String TYPE = "type";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in LispExtensionMappingAddressInterpreter";

    public boolean supported(ExtensionMappingAddressType type) {
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.LIST_ADDRESS.type())) {
            return true;
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.SEGMENT_ADDRESS.type())) {
            return true;
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.AS_ADDRESS.type())) {
            return true;
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.APPLICATION_DATA_ADDRESS.type())) {
            return true;
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.GEO_COORDINATE_ADDRESS.type())) {
            return true;
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.NAT_ADDRESS.type())) {
            return true;
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.NONCE_ADDRESS.type())) {
            return true;
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.MULTICAST_ADDRESS.type())) {
            return true;
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.TRAFFIC_ENGINEERING_ADDRESS.type())) {
            return true;
        }
        return type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.SOURCE_DEST_ADDRESS.type());
    }

    public LispLcafAddress mapMappingAddress(ExtensionMappingAddress mappingAddress) {
        ExtensionMappingAddressType type = mappingAddress.type();
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.LIST_ADDRESS.type())) {
            LispListAddress listAddress = (LispListAddress)mappingAddress;
            LispAfiAddress ipv4 = this.mapping2afi(listAddress.getIpv4());
            LispAfiAddress ipv6 = this.mapping2afi(listAddress.getIpv6());
            if (ipv4 != null && ipv6 != null) {
                return new LispListLcafAddress((List)ImmutableList.of((Object)ipv4, (Object)ipv6));
            }
            return new LispListLcafAddress((List)ImmutableList.of());
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.SEGMENT_ADDRESS.type())) {
            LispSegmentAddress segmentAddress = (LispSegmentAddress)mappingAddress;
            return new LispSegmentLcafAddress.SegmentAddressBuilder().withInstanceId(segmentAddress.getInstanceId()).withAddress(this.getAfiAddress(segmentAddress.getAddress())).build();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.AS_ADDRESS.type())) {
            LispAsAddress asAddress = (LispAsAddress)mappingAddress;
            return new LispAsLcafAddress.AsAddressBuilder().withAsNumber(asAddress.getAsNumber()).withAddress(this.getAfiAddress(asAddress.getAddress())).build();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.APPLICATION_DATA_ADDRESS.type())) {
            LispAppDataAddress appDataAddress = (LispAppDataAddress)mappingAddress;
            return new LispAppDataLcafAddress.AppDataAddressBuilder().withProtocol(appDataAddress.getProtocol()).withIpTos(appDataAddress.getIpTos()).withLocalPortLow(appDataAddress.getLocalPortLow()).withLocalPortHigh(appDataAddress.getLocalPortHigh()).withRemotePortLow(appDataAddress.getRemotePortLow()).withRemotePortHigh(appDataAddress.getRemotePortHigh()).withAddress(this.getAfiAddress(appDataAddress.getAddress())).build();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.GEO_COORDINATE_ADDRESS.type())) {
            LispGcAddress gcAddress = (LispGcAddress)mappingAddress;
            return new LispGeoCoordinateLcafAddress.GeoCoordinateAddressBuilder().withIsNorth(gcAddress.isNorth()).withLatitudeDegree(gcAddress.getLatitudeDegree()).withLatitudeMinute(gcAddress.getLatitudeMinute()).withLatitudeSecond(gcAddress.getLatitudeSecond()).withIsEast(gcAddress.isEast()).withLongitudeDegree(gcAddress.getLongitudeDegree()).withLongitudeMinute(gcAddress.getLongitudeMinute()).withLongitudeSecond(gcAddress.getLongitudeSecond()).withAltitude(gcAddress.getAltitude()).withAddress(this.getAfiAddress(gcAddress.getAddress())).build();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.NAT_ADDRESS.type())) {
            LispNatAddress natAddress = (LispNatAddress)mappingAddress;
            ArrayList aas = Lists.newArrayList();
            natAddress.getRtrRlocAddresses().forEach(rtr -> aas.add(this.getAfiAddress((MappingAddress)rtr)));
            return new LispNatLcafAddress.NatAddressBuilder().withMsUdpPortNumber(natAddress.getMsUdpPortNumber()).withEtrUdpPortNumber(natAddress.getEtrUdpPortNumber()).withMsRlocAddress(this.getAfiAddress(natAddress.getMsRlocAddress())).withGlobalEtrRlocAddress(this.getAfiAddress(natAddress.getGlobalEtrRlocAddress())).withPrivateEtrRlocAddress(this.getAfiAddress(natAddress.getPrivateEtrRlocAddress())).withRtrRlocAddresses((List)aas).build();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.NONCE_ADDRESS.type())) {
            LispNonceAddress nonceAddress = (LispNonceAddress)mappingAddress;
            return new LispNonceLcafAddress.NonceAddressBuilder().withNonce(nonceAddress.getNonce()).withAddress(this.getAfiAddress(nonceAddress.getAddress())).build();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.MULTICAST_ADDRESS.type())) {
            LispMulticastAddress multicastAddress = (LispMulticastAddress)mappingAddress;
            return new LispMulticastLcafAddress.MulticastAddressBuilder().withInstanceId(multicastAddress.getInstanceId()).withSrcAddress(this.getAfiAddress(multicastAddress.getSrcAddress())).withSrcMaskLength(multicastAddress.getSrcMaskLength()).withGrpAddress(this.getAfiAddress(multicastAddress.getGrpAddress())).withGrpMaskLength(multicastAddress.getGrpMaskLength()).build();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.TRAFFIC_ENGINEERING_ADDRESS.type())) {
            LispTeAddress teAddress = (LispTeAddress)mappingAddress;
            ArrayList records = Lists.newArrayList();
            teAddress.getTeRecords().forEach(record -> {
                LispTeRecord teRecord = new LispTeRecord.TeRecordBuilder().withIsLookup(record.isLookup()).withIsRlocProbe(record.isRlocProbe()).withIsStrict(record.isStrict()).withRtrRlocAddress(this.getAfiAddress(record.getAddress())).build();
                records.add(teRecord);
            });
            return new LispTeLcafAddress.TeAddressBuilder().withTeRecords((List)records).build();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.SOURCE_DEST_ADDRESS.type())) {
            LispSrcDstAddress srcDstAddress = (LispSrcDstAddress)mappingAddress;
            return new LispSourceDestLcafAddress.SourceDestAddressBuilder().withSrcPrefix(this.getAfiAddress(srcDstAddress.getSrcPrefix())).withSrcMaskLength(srcDstAddress.getSrcMaskLength()).withDstPrefix(this.getAfiAddress(srcDstAddress.getDstPrefix())).withDstMaskLength(srcDstAddress.getDstMaskLength()).build();
        }
        log.error("Unsupported extension mapping address type {}", (Object)mappingAddress.type());
        return null;
    }

    public ExtensionMappingAddress mapLcafAddress(LispLcafAddress lcafAddress) {
        switch (lcafAddress.getType()) {
            case LIST: {
                LispListLcafAddress lcafListAddress = (LispListLcafAddress)lcafAddress;
                MappingAddress ipv4Ma = this.afi2mapping((LispAfiAddress)lcafListAddress.getAddresses().get(0));
                MappingAddress ipv6Ma = this.afi2mapping((LispAfiAddress)lcafListAddress.getAddresses().get(1));
                return new LispListAddress.Builder().withIpv4(ipv4Ma).withIpv6(ipv6Ma).build();
            }
            case SEGMENT: {
                LispSegmentLcafAddress segmentLcafAddress = (LispSegmentLcafAddress)lcafAddress;
                return new LispSegmentAddress.Builder().withInstanceId(segmentLcafAddress.getInstanceId()).withAddress(this.getMappingAddress(segmentLcafAddress.getAddress())).build();
            }
            case AS: {
                LispAsLcafAddress asLcafAddress = (LispAsLcafAddress)lcafAddress;
                return new LispAsAddress.Builder().withAsNumber(asLcafAddress.getAsNumber()).withAddress(this.getMappingAddress(asLcafAddress.getAddress())).build();
            }
            case APPLICATION_DATA: {
                LispAppDataLcafAddress appLcafAddress = (LispAppDataLcafAddress)lcafAddress;
                return new LispAppDataAddress.Builder().withProtocol(appLcafAddress.getProtocol()).withIpTos(appLcafAddress.getIpTos()).withLocalPortLow(appLcafAddress.getLocalPortLow()).withLocalPortHigh(appLcafAddress.getLocalPortHigh()).withRemotePortLow(appLcafAddress.getRemotePortLow()).withRemotePortHigh(appLcafAddress.getRemotePortHigh()).withAddress(this.getMappingAddress(appLcafAddress.getAddress())).build();
            }
            case GEO_COORDINATE: {
                LispGeoCoordinateLcafAddress gcLcafAddress = (LispGeoCoordinateLcafAddress)lcafAddress;
                return new LispGcAddress.Builder().withIsNorth(gcLcafAddress.isNorth()).withLatitudeDegree(gcLcafAddress.getLatitudeDegree()).withLatitudeMinute(gcLcafAddress.getLatitudeMinute()).withLatitudeSecond(gcLcafAddress.getLatitudeSecond()).withIsEast(gcLcafAddress.isEast()).withLongitudeDegree(gcLcafAddress.getLongitudeDegree()).withLongitudeMinute(gcLcafAddress.getLongitudeMinute()).withLongitudeSecond(gcLcafAddress.getLongitudeSecond()).withAltitude(gcLcafAddress.getAltitude()).withAddress(this.getMappingAddress(gcLcafAddress.getAddress())).build();
            }
            case NAT: {
                LispNatLcafAddress natLcafAddress = (LispNatLcafAddress)lcafAddress;
                ArrayList mas = Lists.newArrayList();
                natLcafAddress.getRtrRlocAddresses().forEach(rtr -> mas.add(this.getMappingAddress((LispAfiAddress)rtr)));
                return new LispNatAddress.Builder().withMsUdpPortNumber(natLcafAddress.getMsUdpPortNumber()).withEtrUdpPortNumber(natLcafAddress.getEtrUdpPortNumber()).withMsRlocAddress(this.getMappingAddress(natLcafAddress.getMsRlocAddress())).withGlobalEtrRlocAddress(this.getMappingAddress(natLcafAddress.getGlobalEtrRlocAddress())).withPrivateEtrRlocAddress(this.getMappingAddress(natLcafAddress.getPrivateEtrRlocAddress())).withRtrRlocAddresses(mas).build();
            }
            case NONCE: {
                LispNonceLcafAddress nonceLcafAddress = (LispNonceLcafAddress)lcafAddress;
                return new LispNonceAddress.Builder().withNonce(nonceLcafAddress.getNonce()).withAddress(this.getMappingAddress(nonceLcafAddress.getAddress())).build();
            }
            case MULTICAST: {
                LispMulticastLcafAddress multiLcafAddress = (LispMulticastLcafAddress)lcafAddress;
                return new LispMulticastAddress.Builder().withInstanceId(multiLcafAddress.getInstanceId()).withSrcAddress(this.getMappingAddress(multiLcafAddress.getSrcAddress())).withSrcMaskLength(multiLcafAddress.getSrcMaskLength()).withGrpAddress(this.getMappingAddress(multiLcafAddress.getGrpAddress())).withGrpMaskLength(multiLcafAddress.getGrpMaskLength()).build();
            }
            case TRAFFIC_ENGINEERING: {
                LispTeLcafAddress teLcafAddress = (LispTeLcafAddress)lcafAddress;
                ArrayList records = Lists.newArrayList();
                teLcafAddress.getTeRecords().forEach(record -> {
                    LispTeAddress.TeRecord teRecord = new LispTeAddress.TeRecord.Builder().withIsLookup(record.isLookup()).withIsRlocProbe(record.isRlocProbe()).withIsStrict(record.isStrict()).withRtrRlocAddress(this.getMappingAddress(record.getRtrRlocAddress())).build();
                    records.add(teRecord);
                });
                return new LispTeAddress.Builder().withTeRecords(records).build();
            }
            case SECURITY: {
                log.warn("security type will be implemented later");
                return null;
            }
            case SOURCE_DEST: {
                LispSourceDestLcafAddress srcDstLcafAddress = (LispSourceDestLcafAddress)lcafAddress;
                return new LispSrcDstAddress.Builder().withSrcPrefix(this.getMappingAddress(srcDstLcafAddress.getSrcPrefix())).withSrcMaskLength(srcDstLcafAddress.getSrcMaskLength()).withDstPrefix(this.getMappingAddress(srcDstLcafAddress.getDstPrefix())).withDstMaskLength(srcDstLcafAddress.getDstMaskLength()).build();
            }
        }
        log.error("Unsupported LCAF type {}", (Object)lcafAddress.getType());
        return null;
    }

    public ExtensionMappingAddress getExtensionMappingAddress(ExtensionMappingAddressType type) {
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.LIST_ADDRESS.type())) {
            return new LispListAddress();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.SEGMENT_ADDRESS.type())) {
            return new LispSegmentAddress();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.AS_ADDRESS.type())) {
            return new LispAsAddress();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.APPLICATION_DATA_ADDRESS.type())) {
            return new LispAppDataAddress();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.GEO_COORDINATE_ADDRESS.type())) {
            return new LispGcAddress();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.NAT_ADDRESS.type())) {
            return new LispNatAddress();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.NONCE_ADDRESS.type())) {
            return new LispNonceAddress();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.MULTICAST_ADDRESS.type())) {
            return new LispMulticastAddress();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.TRAFFIC_ENGINEERING_ADDRESS.type())) {
            return new LispTeAddress();
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.SOURCE_DEST_ADDRESS.type())) {
            return new LispSrcDstAddress();
        }
        return null;
    }

    private MappingAddress afi2mapping(LispAfiAddress afi) {
        switch (afi.getAfi()) {
            case IP4: {
                IpAddress ipv4Address = ((LispIpv4Address)afi).getAddress();
                IpPrefix ipv4Prefix = IpPrefix.valueOf((IpAddress)ipv4Address, (int)32);
                return MappingAddresses.ipv4MappingAddress((IpPrefix)ipv4Prefix);
            }
            case IP6: {
                IpAddress ipv6Address = ((LispIpv6Address)afi).getAddress();
                IpPrefix ipv6Prefix = IpPrefix.valueOf((IpAddress)ipv6Address, (int)128);
                return MappingAddresses.ipv6MappingAddress((IpPrefix)ipv6Prefix);
            }
        }
        log.warn("Only support to convert IP address type");
        return null;
    }

    private LispAfiAddress mapping2afi(MappingAddress address) {
        switch (address.type()) {
            case IPV4: {
                IpPrefix ipv4Prefix = ((IPMappingAddress)address).ip();
                return new LispIpv4Address(ipv4Prefix.address());
            }
            case IPV6: {
                IpPrefix ipv6Prefix = ((IPMappingAddress)address).ip();
                return new LispIpv6Address(ipv6Prefix.address());
            }
        }
        log.warn("Only support to convert IP address type");
        return null;
    }

    private MappingAddress getMappingAddress(LispAfiAddress address) {
        if (address == null) {
            log.warn("Address is not specified.");
            return null;
        }
        switch (address.getAfi()) {
            case IP4: {
                return this.afi2mapping(address);
            }
            case IP6: {
                return this.afi2mapping(address);
            }
            case AS: {
                int asNum = ((org.onosproject.lisp.msg.types.LispAsAddress)address).getASNum();
                return MappingAddresses.asMappingAddress((String)String.valueOf(asNum));
            }
            case DISTINGUISHED_NAME: {
                String dn = ((LispDistinguishedNameAddress)address).getDistinguishedName();
                return MappingAddresses.dnMappingAddress((String)dn);
            }
            case MAC: {
                MacAddress macAddress = ((LispMacAddress)address).getAddress();
                return MappingAddresses.ethMappingAddress((MacAddress)macAddress);
            }
            case LCAF: {
                LispLcafAddress lcafAddress = (LispLcafAddress)address;
                return MappingAddresses.extensionMappingAddressWrapper((ExtensionMappingAddress)this.mapLcafAddress(lcafAddress));
            }
        }
        log.warn("Unsupported address AFI type {}", (Object)address.getAfi());
        return null;
    }

    private LispAfiAddress getAfiAddress(MappingAddress address) {
        if (address == null) {
            log.warn("Address is not specified.");
            return null;
        }
        switch (address.type()) {
            case IPV4: {
                return this.mapping2afi(address);
            }
            case IPV6: {
                return this.mapping2afi(address);
            }
            case AS: {
                int asNum = ((org.onosproject.lisp.msg.types.LispAsAddress)address).getASNum();
                return new org.onosproject.lisp.msg.types.LispAsAddress(asNum);
            }
            case DN: {
                String dn = ((LispDistinguishedNameAddress)address).getDistinguishedName();
                return new LispDistinguishedNameAddress(dn);
            }
            case ETH: {
                MacAddress macAddress = ((LispMacAddress)address).getAddress();
                return new LispMacAddress(macAddress);
            }
            case EXTENSION: {
                ExtensionMappingAddress extAddress = (ExtensionMappingAddress)address;
                return this.mapMappingAddress(extAddress);
            }
        }
        log.warn("Unsupported address type {}", (Object)address.type());
        return null;
    }

    public ObjectNode encode(ExtensionMappingAddress mappingAddress, CodecContext context) {
        Preconditions.checkNotNull((Object)mappingAddress, (Object)"Extension mapping address cannot be null");
        ExtensionMappingAddressType type = mappingAddress.type();
        ObjectNode root = context.mapper().createObjectNode();
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.LIST_ADDRESS.type())) {
            LispListAddress listAddress = (LispListAddress)mappingAddress;
            root.set(LISP_LIST_ADDRESS, (JsonNode)context.codec(LispListAddress.class).encode((Object)listAddress, context));
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.SEGMENT_ADDRESS.type())) {
            LispSegmentAddress segmentAddress = (LispSegmentAddress)mappingAddress;
            root.set(LISP_SEGMENT_ADDRESS, (JsonNode)context.codec(LispSegmentAddress.class).encode((Object)segmentAddress, context));
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.AS_ADDRESS.type())) {
            LispAsAddress asAddress = (LispAsAddress)mappingAddress;
            root.set(LISP_AS_ADDRESS, (JsonNode)context.codec(LispAsAddress.class).encode((Object)asAddress, context));
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.APPLICATION_DATA_ADDRESS.type())) {
            LispAppDataAddress appDataAddress = (LispAppDataAddress)mappingAddress;
            root.set(LISP_APPLICATION_DATA_ADDRESS, (JsonNode)context.codec(LispAppDataAddress.class).encode((Object)appDataAddress, context));
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.GEO_COORDINATE_ADDRESS.type())) {
            LispGcAddress gcAddress = (LispGcAddress)mappingAddress;
            root.set(LISP_GEO_COORDINATE_ADDRESS, (JsonNode)context.codec(LispGcAddress.class).encode((Object)gcAddress, context));
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.NAT_ADDRESS.type())) {
            LispNatAddress natAddress = (LispNatAddress)mappingAddress;
            root.set(LISP_NAT_ADDRESS, (JsonNode)context.codec(LispNatAddress.class).encode((Object)natAddress, context));
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.NONCE_ADDRESS.type())) {
            LispNonceAddress nonceAddress = (LispNonceAddress)mappingAddress;
            root.set(LISP_NONCE_ADDRESS, (JsonNode)context.codec(LispNonceAddress.class).encode((Object)nonceAddress, context));
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.MULTICAST_ADDRESS.type())) {
            LispMulticastAddress multicastAddress = (LispMulticastAddress)mappingAddress;
            root.set(LISP_MULTICAST_ADDRESS, (JsonNode)context.codec(LispMulticastAddress.class).encode((Object)multicastAddress, context));
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.TRAFFIC_ENGINEERING_ADDRESS.type())) {
            LispTeAddress teAddress = (LispTeAddress)mappingAddress;
            root.set(LISP_TRAFFIC_ENGINEERING_ADDRESS, (JsonNode)context.codec(LispTeAddress.class).encode((Object)teAddress, context));
        }
        if (type.equals((Object)ExtensionMappingAddressType.ExtensionMappingAddressTypes.SOURCE_DEST_ADDRESS.type())) {
            LispSrcDstAddress srcDstAddress = (LispSrcDstAddress)mappingAddress;
            root.set(LISP_SOURCE_DEST_ADDRESS, (JsonNode)context.codec(LispSrcDstAddress.class).encode((Object)srcDstAddress, context));
        }
        return root;
    }

    public ExtensionMappingAddress decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        String typeString = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TYPE), (String)"type member is required in LispExtensionMappingAddressInterpreter")).asText();
        if (typeString.equals(ExtensionMappingAddressType.ExtensionMappingAddressTypes.LIST_ADDRESS.name())) {
            return (ExtensionMappingAddress)context.codec(LispListAddress.class).decode(LispExtensionMappingAddressInterpreter.get(json, LISP_LIST_ADDRESS), context);
        }
        if (typeString.equals(ExtensionMappingAddressType.ExtensionMappingAddressTypes.SEGMENT_ADDRESS.name())) {
            return (ExtensionMappingAddress)context.codec(LispSegmentAddress.class).decode(LispExtensionMappingAddressInterpreter.get(json, LISP_SEGMENT_ADDRESS), context);
        }
        if (typeString.equals(ExtensionMappingAddressType.ExtensionMappingAddressTypes.AS_ADDRESS.name())) {
            return (ExtensionMappingAddress)context.codec(LispAsAddress.class).decode(LispExtensionMappingAddressInterpreter.get(json, LISP_AS_ADDRESS), context);
        }
        if (typeString.equals(ExtensionMappingAddressType.ExtensionMappingAddressTypes.APPLICATION_DATA_ADDRESS.name())) {
            return (ExtensionMappingAddress)context.codec(LispAppDataAddress.class).decode(LispExtensionMappingAddressInterpreter.get(json, LISP_APPLICATION_DATA_ADDRESS), context);
        }
        if (typeString.equals(ExtensionMappingAddressType.ExtensionMappingAddressTypes.GEO_COORDINATE_ADDRESS.name())) {
            return (ExtensionMappingAddress)context.codec(LispGcAddress.class).decode(LispExtensionMappingAddressInterpreter.get(json, LISP_GEO_COORDINATE_ADDRESS), context);
        }
        if (typeString.equals(ExtensionMappingAddressType.ExtensionMappingAddressTypes.NAT_ADDRESS.name())) {
            return (ExtensionMappingAddress)context.codec(LispNatAddress.class).decode(LispExtensionMappingAddressInterpreter.get(json, LISP_NAT_ADDRESS), context);
        }
        if (typeString.equals(ExtensionMappingAddressType.ExtensionMappingAddressTypes.NONCE_ADDRESS.name())) {
            return (ExtensionMappingAddress)context.codec(LispNonceAddress.class).decode(LispExtensionMappingAddressInterpreter.get(json, LISP_NONCE_ADDRESS), context);
        }
        if (typeString.equals(ExtensionMappingAddressType.ExtensionMappingAddressTypes.MULTICAST_ADDRESS.name())) {
            return (ExtensionMappingAddress)context.codec(LispMulticastAddress.class).decode(LispExtensionMappingAddressInterpreter.get(json, LISP_MULTICAST_ADDRESS), context);
        }
        if (typeString.equals(ExtensionMappingAddressType.ExtensionMappingAddressTypes.TRAFFIC_ENGINEERING_ADDRESS.name())) {
            return (ExtensionMappingAddress)context.codec(LispTeAddress.class).decode(LispExtensionMappingAddressInterpreter.get(json, LISP_TRAFFIC_ENGINEERING_ADDRESS), context);
        }
        if (typeString.equals(ExtensionMappingAddressType.ExtensionMappingAddressTypes.SOURCE_DEST_ADDRESS.name())) {
            return (ExtensionMappingAddress)context.codec(LispSrcDstAddress.class).decode(LispExtensionMappingAddressInterpreter.get(json, LISP_SOURCE_DEST_ADDRESS), context);
        }
        throw new UnsupportedOperationException("Driver does not support extension type " + typeString);
    }

    private static ObjectNode get(ObjectNode parent, String childName) {
        JsonNode node = parent.path(childName);
        return node.isObject() && !node.isNull() ? (ObjectNode)node : null;
    }
}

