/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.flow.AbstractExtension;

public final class LispAsAddress
extends AbstractExtension
implements ExtensionMappingAddress {
    private static final String AS_NUMBER = "asNumber";
    private static final String ADDRESS = "address";
    private int asNumber;
    private MappingAddress address;

    public LispAsAddress() {
    }

    private LispAsAddress(int asNumber, MappingAddress address) {
        this.asNumber = asNumber;
        this.address = address;
    }

    public int getAsNumber() {
        return this.asNumber;
    }

    public MappingAddress getAddress() {
        return this.address;
    }

    public ExtensionMappingAddressType type() {
        return ExtensionMappingAddressType.ExtensionMappingAddressTypes.AS_ADDRESS.type();
    }

    public byte[] serialize() {
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put(AS_NUMBER, this.asNumber);
        parameterMap.put(ADDRESS, this.address);
        return APP_KRYO.serialize((Object)parameterMap);
    }

    public void deserialize(byte[] data) {
        Map parameterMap = (Map)APP_KRYO.deserialize(data);
        this.asNumber = (Integer)parameterMap.get(AS_NUMBER);
        this.address = (MappingAddress)parameterMap.get(ADDRESS);
    }

    public int hashCode() {
        return Objects.hash(this.asNumber, this.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispAsAddress) {
            LispAsAddress other = (LispAsAddress)((Object)obj);
            return Objects.equals(this.asNumber, other.asNumber) && Objects.equals(this.address, other.address);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add("AS number", this.asNumber).add(ADDRESS, (Object)this.address).toString();
    }

    public static final class Builder {
        private int asNumber;
        private MappingAddress address;

        public Builder withAsNumber(int asNumber) {
            this.asNumber = asNumber;
            return this;
        }

        public Builder withAddress(MappingAddress address) {
            this.address = address;
            return this;
        }

        public LispAsAddress build() {
            return new LispAsAddress(this.asNumber, this.address);
        }
    }
}

