/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lisp.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.flow.AbstractExtension;

public final class LispAppDataAddress
extends AbstractExtension
implements ExtensionMappingAddress {
    private static final String PROTOCOL = "protocol";
    private static final String IP_TOS = "ipTos";
    private static final String LOCAL_PORT_LOW = "localPortLow";
    private static final String LOCAL_PORT_HIGH = "localPortHigh";
    private static final String REMOTE_PORT_LOW = "remotePortLow";
    private static final String REMOTE_PORT_HIGH = "remotePortHigh";
    private static final String ADDRESS = "address";
    private byte protocol;
    private int ipTos;
    private short localPortLow;
    private short localPortHigh;
    private short remotePortLow;
    private short remotePortHigh;
    private MappingAddress address;

    public LispAppDataAddress() {
    }

    private LispAppDataAddress(byte protocol, int ipTos, short localPortLow, short localPortHigh, short remotePortLow, short remotePortHigh, MappingAddress address) {
        this.protocol = protocol;
        this.ipTos = ipTos;
        this.localPortLow = localPortLow;
        this.localPortHigh = localPortHigh;
        this.remotePortLow = remotePortLow;
        this.remotePortHigh = remotePortHigh;
        this.address = address;
    }

    public byte getProtocol() {
        return this.protocol;
    }

    public int getIpTos() {
        return this.ipTos;
    }

    public short getLocalPortLow() {
        return this.localPortLow;
    }

    public short getLocalPortHigh() {
        return this.localPortHigh;
    }

    public short getRemotePortLow() {
        return this.remotePortLow;
    }

    public short getRemotePortHigh() {
        return this.remotePortHigh;
    }

    public MappingAddress getAddress() {
        return this.address;
    }

    public ExtensionMappingAddressType type() {
        return ExtensionMappingAddressType.ExtensionMappingAddressTypes.APPLICATION_DATA_ADDRESS.type();
    }

    public byte[] serialize() {
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put(PROTOCOL, this.protocol);
        parameterMap.put(IP_TOS, this.ipTos);
        parameterMap.put(LOCAL_PORT_LOW, this.localPortLow);
        parameterMap.put(LOCAL_PORT_HIGH, this.localPortHigh);
        parameterMap.put(REMOTE_PORT_LOW, this.remotePortLow);
        parameterMap.put(REMOTE_PORT_HIGH, this.remotePortHigh);
        parameterMap.put(ADDRESS, this.address);
        return APP_KRYO.serialize((Object)parameterMap);
    }

    public void deserialize(byte[] data) {
        Map parameterMap = (Map)APP_KRYO.deserialize(data);
        this.protocol = (Byte)parameterMap.get(PROTOCOL);
        this.ipTos = (Integer)parameterMap.get(IP_TOS);
        this.localPortLow = (Short)parameterMap.get(LOCAL_PORT_LOW);
        this.localPortHigh = (Short)parameterMap.get(LOCAL_PORT_HIGH);
        this.remotePortLow = (Short)parameterMap.get(REMOTE_PORT_LOW);
        this.remotePortHigh = (Short)parameterMap.get(REMOTE_PORT_HIGH);
        this.address = (MappingAddress)parameterMap.get(ADDRESS);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.ipTos, this.localPortLow, this.localPortHigh, this.remotePortLow, this.remotePortHigh, this.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispAppDataAddress) {
            LispAppDataAddress that = (LispAppDataAddress)((Object)obj);
            return Objects.equals(this.protocol, that.protocol) && Objects.equals(this.ipTos, that.ipTos) && Objects.equals(this.localPortLow, that.localPortLow) && Objects.equals(this.localPortHigh, that.localPortHigh) && Objects.equals(this.remotePortLow, that.remotePortLow) && Objects.equals(this.remotePortHigh, that.remotePortHigh) && Objects.equals(this.address, that.address);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.type().toString()).add(PROTOCOL, (int)this.protocol).add("IP type of service", this.ipTos).add("low-ranged local port number", (int)this.localPortLow).add("high-ranged local port number", (int)this.localPortHigh).add("low-ranged remote port number", (int)this.remotePortLow).add("high-ranged remote port number", (int)this.remotePortHigh).add(ADDRESS, (Object)this.address).toString();
    }

    public static final class Builder {
        private byte protocol;
        private int ipTos;
        private short localPortLow;
        private short localPortHigh;
        private short remotePortLow;
        private short remotePortHigh;
        private MappingAddress address;

        public Builder withProtocol(byte protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder withIpTos(int ipTos) {
            this.ipTos = ipTos;
            return this;
        }

        public Builder withLocalPortLow(short localPortLow) {
            this.localPortLow = localPortLow;
            return this;
        }

        public Builder withLocalPortHigh(short localPortHigh) {
            this.localPortHigh = localPortHigh;
            return this;
        }

        public Builder withRemotePortLow(short remotePortLow) {
            this.remotePortLow = remotePortLow;
            return this;
        }

        public Builder withRemotePortHigh(short remotePortHigh) {
            this.remotePortHigh = remotePortHigh;
            return this;
        }

        public Builder withAddress(MappingAddress address) {
            this.address = address;
            return this;
        }

        public LispAppDataAddress build() {
            return new LispAppDataAddress(this.protocol, this.ipTos, this.localPortLow, this.localPortHigh, this.remotePortLow, this.remotePortHigh, this.address);
        }
    }
}

